/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.bungee.factory;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.injector.ChannelInjector;
import com.github.retrooper.packetevents.manager.InternalPacketListener;
import com.github.retrooper.packetevents.manager.player.PlayerManager;
import com.github.retrooper.packetevents.manager.protocol.ProtocolManager;
import com.github.retrooper.packetevents.manager.server.ServerManager;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.netty.NettyManager;
import com.github.retrooper.packetevents.netty.channel.ChannelHelper;
import com.github.retrooper.packetevents.protocol.ConnectionState;
import com.github.retrooper.packetevents.protocol.ProtocolVersion;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.settings.PacketEventsSettings;
import com.github.retrooper.packetevents.util.LogManager;
import io.github.retrooper.packetevents.bstats.bungeecord.Metrics;
import io.github.retrooper.packetevents.bstats.charts.SimplePie;
import io.github.retrooper.packetevents.impl.netty.NettyManagerImpl;
import io.github.retrooper.packetevents.impl.netty.manager.player.PlayerManagerAbstract;
import io.github.retrooper.packetevents.impl.netty.manager.protocol.ProtocolManagerAbstract;
import io.github.retrooper.packetevents.impl.netty.manager.server.ServerManagerAbstract;
import io.github.retrooper.packetevents.injector.BungeePipelineInjector;
import io.github.retrooper.packetevents.processor.InternalBungeeProcessor;
import java.util.Objects;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.kyori.adventure.text.format.NamedTextColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.protocol.ProtocolConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BungeePacketEventsBuilder {
    private static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-ORX]");
    private static PacketEventsAPI<Plugin> INSTANCE;

    public static void clearBuildCache() {
        INSTANCE = null;
    }

    public static PacketEventsAPI<Plugin> build(Plugin plugin) {
        if (INSTANCE == null) {
            INSTANCE = BungeePacketEventsBuilder.buildNoCache(plugin);
        }
        return INSTANCE;
    }

    public static PacketEventsAPI<Plugin> build(Plugin plugin, PacketEventsSettings settings) {
        if (INSTANCE == null) {
            INSTANCE = BungeePacketEventsBuilder.buildNoCache(plugin, settings);
        }
        return INSTANCE;
    }

    public static PacketEventsAPI<Plugin> buildNoCache(Plugin plugin) {
        return BungeePacketEventsBuilder.buildNoCache(plugin, new PacketEventsSettings());
    }

    public static PacketEventsAPI<Plugin> buildNoCache(final Plugin plugin, final PacketEventsSettings inSettings) {
        return new PacketEventsAPI<Plugin>(){
            private final PacketEventsSettings settings;
            private final ProtocolManager protocolManager;
            private final ServerManager serverManager;
            private final PlayerManagerAbstract playerManager;
            private final ChannelInjector injector;
            private final NettyManager nettyManager;
            private final LogManager logManager;
            private boolean loaded;
            private boolean initialized;
            private boolean terminated;
            {
                this.settings = inSettings;
                this.protocolManager = new ProtocolManagerAbstract(){

                    @Override
                    public ProtocolVersion getPlatformVersion() {
                        return ProtocolVersion.UNKNOWN;
                    }
                };
                this.serverManager = new ServerManagerAbstract(){
                    private ServerVersion version;

                    @Override
                    public ServerVersion getVersion() {
                        if (this.version == null) {
                            this.version = ServerVersion.getById((Integer)ProtocolConstants.SUPPORTED_VERSION_IDS.get(0));
                            if (this.version == null) {
                                logManager.warn("PacketEvents currently does not support the protocol version " + ProtocolConstants.SUPPORTED_VERSION_IDS.get(0) + " but will act as if the minecraft version were " + ServerVersion.getLatest().getReleaseName() + "!");
                                this.version = ServerVersion.getLatest();
                            }
                        }
                        return this.version;
                    }

                    @Override
                    public Object getRegistryCacheKey(User user, ClientVersion version) {
                        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(user.getUUID());
                        if (player == null) {
                            return null;
                        }
                        Server server = player.getServer();
                        if (server == null) {
                            return null;
                        }
                        return Objects.hash(new Object[]{server.getInfo(), version});
                    }
                };
                this.playerManager = new PlayerManagerAbstract(){

                    @Override
                    public int getPing(@NotNull Object player) {
                        return ((ProxiedPlayer)player).getPing();
                    }

                    @Override
                    public Object getChannel(@NotNull Object player) {
                        return PacketEvents.getAPI().getProtocolManager().getChannel(((ProxiedPlayer)player).getUniqueId());
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public User getUser(@NotNull Object player) {
                        UserProfile profile;
                        ProxiedPlayer p = (ProxiedPlayer)player;
                        Object channel = this.getChannel(p);
                        User user = PacketEvents.getAPI().getProtocolManager().getUser(channel);
                        if (channel == null) {
                            return null;
                        }
                        if (user == null) {
                            PacketEvents.getAPI().getLogManager().warn("User is null?");
                            user = new User(channel, ConnectionState.PLAY, null, new UserProfile(p.getUniqueId(), p.getName()));
                            Object object = channel;
                            synchronized (object) {
                                if (!ChannelHelper.isOpen(channel)) {
                                    return null;
                                }
                                PacketEvents.getAPI().getProtocolManager().setUser(channel, user);
                                PacketEvents.getAPI().getInjector().updateUser(channel, user);
                            }
                        }
                        if ((profile = user.getProfile()).getName() == null) {
                            profile.setName(p.getName());
                        }
                        if (profile.getUUID() == null) {
                            profile.setUUID(p.getUniqueId());
                        }
                        return user;
                    }
                };
                this.injector = new BungeePipelineInjector();
                this.nettyManager = new NettyManagerImpl();
                this.logManager = new LogManager(){

                    @Override
                    protected void log(Level level, @Nullable NamedTextColor color, String message) {
                        message = STRIP_COLOR_PATTERN.matcher(message).replaceAll("");
                        ProxyServer.getInstance().getLogger().info(message);
                    }
                };
            }

            @Override
            public void load() {
                if (!this.loaded) {
                    String id = plugin.getDescription().getName();
                    PacketEvents.IDENTIFIER = "pe-" + id;
                    PacketEvents.ENCODER_NAME = "pe-encoder-" + id;
                    PacketEvents.DECODER_NAME = "pe-decoder-" + id;
                    PacketEvents.CONNECTION_HANDLER_NAME = "pe-connection-handler-" + id;
                    PacketEvents.SERVER_CHANNEL_HANDLER_NAME = "pe-connection-initializer-" + id;
                    PacketEvents.TIMEOUT_HANDLER_NAME = "pe-timeout-handler-" + id;
                    WrappedBlockState.ensureLoad();
                    this.injector.inject();
                    this.loaded = true;
                    this.getEventManager().registerListener(new InternalPacketListener());
                }
            }

            @Override
            public boolean isLoaded() {
                return this.loaded;
            }

            @Override
            public void init() {
                this.load();
                if (!this.initialized) {
                    ProxyServer.getInstance().getPluginManager().registerListener(plugin, (Listener)new InternalBungeeProcessor());
                    if (this.settings.shouldCheckForUpdates()) {
                        this.getUpdateChecker().handleUpdateCheck();
                    }
                    Metrics metrics = new Metrics(plugin, 11327);
                    metrics.addCustomChart(new SimplePie("packetevents_version", () -> this.getVersion().toStringWithoutSnapshot()));
                    PacketType.Play.Client.load();
                    PacketType.Play.Server.load();
                    this.initialized = true;
                }
            }

            @Override
            public boolean isInitialized() {
                return this.initialized;
            }

            @Override
            public void terminate() {
                if (this.initialized) {
                    this.injector.uninject();
                    this.getEventManager().unregisterAllListeners();
                    this.initialized = false;
                    this.terminated = true;
                }
            }

            @Override
            public boolean isTerminated() {
                return this.terminated;
            }

            @Override
            public Plugin getPlugin() {
                return plugin;
            }

            @Override
            public LogManager getLogManager() {
                return this.logManager;
            }

            @Override
            public ProtocolManager getProtocolManager() {
                return this.protocolManager;
            }

            @Override
            public ServerManager getServerManager() {
                return this.serverManager;
            }

            @Override
            public PlayerManager getPlayerManager() {
                return this.playerManager;
            }

            @Override
            public ChannelInjector getInjector() {
                return this.injector;
            }

            @Override
            public PacketEventsSettings getSettings() {
                return this.settings;
            }

            @Override
            public NettyManager getNettyManager() {
                return this.nettyManager;
            }
        };
    }
}

