/*
 * Decompiled with CFR 0.152.
 */
package io.github.retrooper.packetevents.injector;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.injector.ChannelInjector;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.util.reflection.Reflection;
import io.github.retrooper.packetevents.handlers.PacketEventsDecoder;
import io.github.retrooper.packetevents.handlers.PacketEventsEncoder;
import io.github.retrooper.packetevents.injector.BungeeChannelInitializer;
import io.github.retrooper.packetevents.injector.SetWrapper;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.lang.reflect.Field;
import java.util.Set;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class BungeePipelineInjector
implements ChannelInjector {
    private static final Field LISTENERS_FIELD = Reflection.getField(ProxyServer.getInstance().getClass(), "listeners");

    public void injectChannel(Channel channel) {
        BungeeChannelInitializer newInitializer;
        Field initializerField = null;
        ChannelHandler bootstrapAcceptor = null;
        for (String channelName : channel.pipeline().names()) {
            if (channelName.contains("QueryHandler")) {
                return;
            }
            ChannelHandler handler = channel.pipeline().get(channelName);
            if (handler == null) continue;
            try {
                Field f = handler.getClass().getDeclaredField("childHandler");
                f.setAccessible(true);
                bootstrapAcceptor = handler;
                initializerField = f;
            }
            catch (Exception exception) {}
        }
        if (bootstrapAcceptor == null) {
            bootstrapAcceptor = channel.pipeline().first();
            try {
                initializerField = bootstrapAcceptor.getClass().getDeclaredField("childHandler");
                initializerField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            newInitializer = new BungeeChannelInitializer(initializerField.get(bootstrapAcceptor));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        try {
            initializerField.set(bootstrapAcceptor, (Object)newInitializer);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void inject() {
        try {
            Set listeners = (Set)LISTENERS_FIELD.get(ProxyServer.getInstance());
            for (Channel channel : listeners) {
                this.injectChannel(channel);
            }
            SetWrapper<Channel> wrapper = new SetWrapper<Channel>(listeners, this::injectChannel);
            LISTENERS_FIELD.set(ProxyServer.getInstance(), wrapper);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void uninject() {
    }

    @Override
    public void setPlayer(Object ch, Object p) {
        Channel channel = (Channel)ch;
        ProxiedPlayer player = (ProxiedPlayer)p;
        PacketEventsDecoder decoder = (PacketEventsDecoder)channel.pipeline().get(PacketEvents.DECODER_NAME);
        decoder.player = player;
        decoder.user.getProfile().setUUID(player.getUniqueId());
        decoder.user.getProfile().setName(player.getName());
        PacketEventsEncoder encoder = (PacketEventsEncoder)channel.pipeline().get(PacketEvents.ENCODER_NAME);
        encoder.player = player;
    }

    @Override
    public boolean isPlayerSet(Object ch) {
        if (ch == null) {
            return false;
        }
        Channel channel = (Channel)ch;
        PacketEventsEncoder encoder = (PacketEventsEncoder)channel.pipeline().get(PacketEvents.ENCODER_NAME);
        if (encoder.player != null) {
            return true;
        }
        PacketEventsDecoder decoder = (PacketEventsDecoder)channel.pipeline().get(PacketEvents.DECODER_NAME);
        return decoder.player != null;
    }

    @Override
    public void updateUser(Object ch, User user) {
        Channel channel = (Channel)ch;
        PacketEventsDecoder decoder = (PacketEventsDecoder)channel.pipeline().get(PacketEvents.DECODER_NAME);
        decoder.user = user;
        PacketEventsEncoder encoder = (PacketEventsEncoder)channel.pipeline().get(PacketEvents.ENCODER_NAME);
        encoder.user = user;
    }

    @Override
    public boolean isProxy() {
        return true;
    }

    static {
        LISTENERS_FIELD.setAccessible(true);
    }
}

