/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher;

import com.cleanroommc.relauncher.config.RelauncherConfiguration;
import com.cleanroommc.relauncher.download.CleanroomRelease;
import com.cleanroommc.relauncher.download.cache.CleanroomCache;
import com.cleanroommc.relauncher.download.schema.Version;
import com.cleanroommc.relauncher.gui.RelauncherGUI;
import com.cleanroommc.relauncher.shade.javautils.JavaUtils;
import com.cleanroommc.relauncher.shade.javautils.api.JavaVersion;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.cleanroomrelauncher.ExitVMBypass;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CleanroomRelauncher {
    public static final Logger LOGGER = LogManager.getLogger((String)"CleanroomRelauncher");
    public static final Gson GSON = new Gson();
    public static final Path CACHE_DIR = Paths.get(System.getProperty("user.home"), ".cleanroom", "relauncher");
    public static RelauncherConfiguration CONFIG = RelauncherConfiguration.read();

    private static boolean isCleanroom() {
        try {
            Class.forName("com.cleanroommc.boot.Main");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    void run() {
        String wrapperClassPath;
        List<Version> versions;
        boolean needsNotifyLatest;
        CleanroomRelease latestRelease;
        List<CleanroomRelease> releases;
        if (CleanroomRelauncher.isCleanroom()) {
            LOGGER.info("Cleanroom detected. No need to relaunch!");
            return;
        }
        if (JavaVersion.parseOrThrow(System.getProperty("java.version")).build() <= 101) {
            try (InputStream is = this.getClass().getResource("/cacerts").openStream();){
                File cacertsCopy = File.createTempFile("cacerts", "");
                cacertsCopy.deleteOnExit();
                FileUtils.copyInputStreamToFile((InputStream)is, (File)cacertsCopy);
                System.setProperty("javax.net.ssl.trustStore", cacertsCopy.getAbsolutePath());
                LOGGER.info("Successfully replaced CA Certs.");
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to replace CA Certs!", e);
            }
        }
        try {
            releases = CleanroomRelease.queryAll();
            latestRelease = releases.get(0);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to query Cleanroom's releases.", e);
        }
        LOGGER.info("{} cleanroom releases were queried.", (Object)releases.size());
        CleanroomRelease selected = null;
        String selectedVersion = CONFIG.getCleanroomVersion();
        String notedLatestVersion = CONFIG.getLatestCleanroomVersion();
        String javaPath = CONFIG.getJavaExecutablePath();
        String javaArgs = CONFIG.getJavaArguments();
        boolean bl = needsNotifyLatest = notedLatestVersion == null || !notedLatestVersion.equals(latestRelease.name);
        if (selectedVersion != null) {
            selected = releases.stream().filter(cr -> cr.name.equals(selectedVersion)).findFirst().get();
        }
        if (javaPath != null && !new File(javaPath).isFile()) {
            javaPath = null;
        }
        if (selected == null || javaPath == null || needsNotifyLatest) {
            CleanroomRelease fSelected = selected;
            String fJavaPath = javaPath;
            String fJavaArgs = javaArgs;
            RelauncherGUI gui = RelauncherGUI.show(releases, $ -> {
                $.selected = fSelected;
                $.javaPath = fJavaPath;
                $.javaArgs = fJavaArgs;
            });
            selected = gui.selected;
            javaPath = gui.javaPath;
            javaArgs = gui.javaArgs;
            CONFIG.setCleanroomVersion(selected.name);
            CONFIG.setLatestCleanroomVersion(latestRelease.name);
            CONFIG.setJavaExecutablePath(javaPath);
            CONFIG.setJavaArguments(javaArgs);
            CONFIG.save();
        }
        CleanroomCache releaseCache = CleanroomCache.of(selected);
        LOGGER.info("Preparing Cleanroom v{} and its libraries...", (Object)selected.name);
        try {
            versions = releaseCache.download();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to grab CleanroomVersion to relaunch.", e);
        }
        try {
            Path wrapperFile = CACHE_DIR.resolve("wrapper/com/cleanroommc/relauncher/wrapper/RelaunchMainWrapperV2.class");
            Iterator wrapperDirectory = wrapperFile.getParent();
            if (!Files.exists(wrapperFile, new LinkOption[0])) {
                Files.createDirectories((Path)((Object)wrapperDirectory), new FileAttribute[0]);
                try (Stream<Path> wrapperDirectoryStream = Files.walk((Path)((Object)wrapperDirectory), new FileVisitOption[0]);){
                    wrapperDirectoryStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).forEach(File::delete);
                }
                File relauncherJarFile = JavaUtils.jarLocationOf(CleanroomRelauncher.class);
                try (FileSystem containerFs = FileSystems.newFileSystem(relauncherJarFile.toPath(), null);){
                    Path wrapperJarDirectory = containerFs.getPath("/wrapper/", new String[0]);
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(wrapperJarDirectory);){
                        for (Path path : stream) {
                            Path to = wrapperFile.resolveSibling(path.getFileName().toString());
                            Files.copy(path, to, new CopyOption[0]);
                            LOGGER.debug("Moved {} to {}", (Object)path.toAbsolutePath().toString(), (Object)to.toAbsolutePath().toString());
                        }
                    }
                }
            }
            wrapperClassPath = CACHE_DIR.resolve("wrapper").toAbsolutePath().toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to extract RelaunchMainWrapper class to cache directory", e);
        }
        LOGGER.info("Preparing to relaunch Cleanroom v{}", (Object)selected.name);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(javaPath);
        arguments.add("-cp");
        arguments.add(wrapperClassPath + File.pathSeparator + versions.stream().map(version -> version.libraryPaths).flatMap(Collection::stream).collect(Collectors.joining(File.pathSeparator)));
        for (String argument : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            if (argument.startsWith("-Djava.library.path")) continue;
            arguments.add(argument);
        }
        arguments.add("-Djava.library.path=" + versions.stream().map(version -> version.nativesPaths).flatMap(Collection::stream).collect(Collectors.joining(File.pathSeparator)));
        arguments.add("com.cleanroommc.relauncher.wrapper.RelaunchMainWrapperV2");
        for (Map.Entry launchArgument : ((Map)Launch.blackboard.get("launchArgs")).entrySet()) {
            arguments.add((String)launchArgument.getKey());
            arguments.add((String)launchArgument.getValue());
        }
        arguments.add("--tweakClass");
        arguments.add("net.minecraftforge.fml.common.launcher.FMLTweaker");
        arguments.add("--mainClass");
        arguments.add(versions.get((int)0).mainClass);
        LOGGER.debug("Arguments:");
        for (String arg : arguments) {
            LOGGER.debug(arg);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(arguments);
        processBuilder.directory(null);
        processBuilder.inheritIO();
        try {
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            LOGGER.info("Process exited with code: {}", (Object)exitCode);
            ExitVMBypass.exit(exitCode);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

