/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.config;

import com.cleanroommc.relauncher.CleanroomRelauncher;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.launchwrapper.Launch;

public class RelauncherConfiguration {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final File FILE = new File(Launch.minecraftHome, "config/relauncher.json");
    @SerializedName(value="selectedVersion")
    private String cleanroomVersion;
    @SerializedName(value="latestVersion")
    private String latestCleanroomVersion;
    @SerializedName(value="javaPath")
    private String javaExecutablePath;
    @SerializedName(value="args")
    private String javaArguments;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RelauncherConfiguration read() {
        if (!FILE.exists()) {
            return new RelauncherConfiguration();
        }
        try (FileReader reader = new FileReader(FILE);){
            RelauncherConfiguration relauncherConfiguration = (RelauncherConfiguration)GSON.fromJson((Reader)reader, RelauncherConfiguration.class);
            return relauncherConfiguration;
        }
        catch (IOException e) {
            CleanroomRelauncher.LOGGER.error("Unable to read config", (Throwable)e);
            return new RelauncherConfiguration();
        }
    }

    public String getCleanroomVersion() {
        return this.cleanroomVersion;
    }

    public String getLatestCleanroomVersion() {
        return this.latestCleanroomVersion;
    }

    public String getJavaExecutablePath() {
        return this.javaExecutablePath;
    }

    public String getJavaArguments() {
        return this.javaArguments;
    }

    public void setCleanroomVersion(String cleanroomVersion) {
        this.cleanroomVersion = cleanroomVersion;
    }

    public void setLatestCleanroomVersion(String latestCleanroomVersion) {
        this.latestCleanroomVersion = latestCleanroomVersion;
    }

    public void setJavaExecutablePath(String javaExecutablePath) {
        this.javaExecutablePath = javaExecutablePath.replace("\\\\", "/");
    }

    public void setJavaArguments(String javaArguments) {
        this.javaArguments = javaArguments;
    }

    public void save() {
        FILE.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(FILE);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            CleanroomRelauncher.LOGGER.error("Unable to save config", (Throwable)e);
        }
    }

    static {
        File oldConfig = new File(Launch.minecraftHome, "cleanroom-relauncher-v1.properties");
        if (oldConfig.exists()) {
            oldConfig.delete();
        }
    }
}

