/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.download;

import com.cleanroommc.relauncher.CleanroomRelauncher;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

public class CleanroomRelease {
    public String name;
    @SerializedName(value="tag_name")
    public String tagName;
    public List<Asset> assets;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<CleanroomRelease> queryAll() throws IOException {
        try {
            URL url = new URL("https://api.github.com/repos/CleanroomMC/Cleanroom/releases");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
            if (connection.getResponseCode() != 200) {
                throw new IOException("Failed to fetch releases: HTTP error code " + connection.getResponseCode());
            }
            try (InputStreamReader reader = new InputStreamReader(connection.getInputStream());){
                List list = (List)CleanroomRelauncher.GSON.fromJson((Reader)reader, new TypeToken<List<CleanroomRelease>>(){}.getType());
                return list;
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to fetch or parse releases", e);
        }
    }

    public Asset getInstallerArtifact() {
        for (Asset asset : this.assets) {
            if (!asset.name.endsWith("-installer.jar")) continue;
            return asset;
        }
        return null;
    }

    @Deprecated
    public Asset getMultiMcPackArtifact() {
        for (Asset asset : this.assets) {
            if (!asset.name.endsWith(".zip") || !asset.name.contains("MMC")) continue;
            return asset;
        }
        return null;
    }

    public static class Asset {
        public String name;
        @SerializedName(value="browser_download_url")
        public String downloadUrl;
        public long size;
    }
}

