/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.download;

import com.cleanroommc.relauncher.CleanroomRelauncher;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;

public final class GlobalDownloader {
    public static final GlobalDownloader INSTANCE = new GlobalDownloader();
    private final List<ForkJoinTask> downloads = new ArrayList<ForkJoinTask>();

    public void from(String source, File destination) {
        URL url;
        URI uri;
        try {
            uri = URI.create(source);
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.format("Unable to construct url %s", source), e);
        }
        this.downloads.add((ForkJoinTask)ForkJoinPool.commonPool().submit(() -> {
            try {
                FileUtils.copyURLToFile((URL)url, (File)destination);
                CleanroomRelauncher.LOGGER.debug("Downloaded {} to {}", (Object)uri.toString(), (Object)destination.getAbsolutePath());
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Unable to download %s to %s", url, destination), e);
            }
        }));
    }

    public void immediatelyFrom(String source, File destination) {
        this.from(source, destination);
        try {
            this.downloads.remove(this.downloads.size() - 1).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unable to complete download", e);
        }
    }

    public void blockUntilFinished() {
        int total = this.downloads.size();
        int completed = 0;
        int last = 0;
        for (Future future : this.downloads) {
            try {
                int percentage;
                future.get();
                if ((percentage = ++completed * 100 / total) % 10 != 0 || last == percentage) continue;
                last = percentage;
                CleanroomRelauncher.LOGGER.info("Download Progress: {} / {} | {}% completed.", (Object)completed, (Object)total, (Object)percentage);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Unable to complete download", e);
            }
        }
    }
}

