/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.download.schema;

import com.cleanroommc.relauncher.CleanroomRelauncher;
import com.cleanroommc.relauncher.download.GlobalDownloader;
import com.cleanroommc.relauncher.util.Platform;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class Version {
    private static final Map<Platform.OperatingSystem, String> OS_NAMES = new HashMap<Platform.OperatingSystem, String>();
    public String minecraftArguments;
    public AssetIndex assetIndex;
    public String assets;
    public int complianceLevel;
    public Map<String, Download> downloads;
    public String id;
    public Library mainJar;
    public List<Library> libraries;
    public Object logging;
    public String mainClass;
    public int minimumLauncherVersion;
    public String releaseTime;
    public String time;
    public String type;
    public transient List<String> libraryPaths = new ArrayList<String>();
    public transient List<String> nativesPaths = new ArrayList<String>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Version parse(Path path) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(path, new OpenOption[0]));){
            Version version = (Version)CleanroomRelauncher.GSON.fromJson((Reader)reader, Version.class);
            return version;
        }
        catch (IOException e) {
            throw new IOException("Unable to parse version.json", e);
        }
    }

    public void downloadLibraries(Path librariesDirectory) {
        if (this.mainJar != null) {
            this.libraries.add(this.mainJar);
        }
        for (Library library : this.libraries) {
            Path nativesJar;
            Download nativeArtifact;
            if (library.downloads == null) continue;
            Path libraryJar = librariesDirectory.resolve(library.downloads.artifact.getPath(library.name));
            if (!Files.exists(libraryJar, new LinkOption[0])) {
                GlobalDownloader.INSTANCE.from(library.downloads.artifact.url, libraryJar.toFile());
            }
            if ((nativeArtifact = library.getNative(Platform.CURRENT)) != null && !Files.exists(nativesJar = librariesDirectory.resolve(nativeArtifact.getPath(library.name)), new LinkOption[0])) {
                GlobalDownloader.INSTANCE.from(nativeArtifact.url, nativesJar.toFile());
            }
            this.libraryPaths.add(libraryJar.toAbsolutePath().toString());
        }
    }

    public void extractNatives(Path librariesDirectory, Path nativesDirectory) {
        for (Library library : this.libraries) {
            Download nativeArtifact = library.getNative(Platform.CURRENT);
            if (nativeArtifact == null) continue;
            String relative = nativeArtifact.getPath(library.name);
            Path jarPath = librariesDirectory.resolve(relative);
            Path nativesPath = nativesDirectory.resolve(relative.substring(0, relative.lastIndexOf(46)));
            this.nativesPaths.add(nativesPath.toAbsolutePath().toString());
            try {
                FileSystem jarFs = FileSystems.newFileSystem(jarPath, null);
                Throwable throwable = null;
                try {
                    Stream<Path> walk = Files.walk(jarFs.getPath("/", new String[0]), new FileVisitOption[0]);
                    Throwable throwable2 = null;
                    try {
                        walk.filter(path -> !path.startsWith("/META-INF/")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                            String pathString = path.toString();
                            if (pathString.startsWith("/")) {
                                pathString = pathString.substring(1);
                            }
                            Path nativesRelativePath = nativesPath.resolve(pathString);
                            try {
                                if (!Files.exists(nativesRelativePath, new LinkOption[0])) {
                                    Files.createDirectories(nativesRelativePath.getParent(), new FileAttribute[0]);
                                    Files.copy(path, nativesRelativePath, new CopyOption[0]);
                                }
                            }
                            catch (IOException e) {
                                throw new RuntimeException(String.format("Unable to unzip and copy file %s to %s", path, nativesRelativePath), e);
                            }
                        });
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (walk == null) continue;
                        if (throwable2 != null) {
                            try {
                                walk.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        walk.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (jarFs == null) continue;
                    if (throwable != null) {
                        try {
                            jarFs.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    jarFs.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Unable to extract from jar %s for its natives", jarPath), e);
            }
        }
    }

    static {
        OS_NAMES.put(Platform.OperatingSystem.WINDOWS, "windows");
        OS_NAMES.put(Platform.OperatingSystem.MAC_OS, "osx");
        OS_NAMES.put(Platform.OperatingSystem.LINUX, "linux");
    }

    public class Download {
        public String path;
        public String sha1;
        public long size;
        public String url;

        @Deprecated
        public String getPath(String name) {
            if (this.path == null) {
                if (this.url.startsWith("https://libraries.minecraft.net/")) {
                    this.path = this.url.substring("https://libraries.minecraft.net/".length());
                } else {
                    String[] splits = name.split(":");
                    String groupId = splits[0];
                    String artifactId = splits[1];
                    String version = splits[2];
                    String groupPath = groupId.replace('.', '/');
                    this.path = String.format("%s/%s/%s/%s-%s.jar", groupPath, artifactId, version, artifactId, version);
                }
            }
            return this.path;
        }
    }

    public class OS {
        public String name;

        public boolean isValidForOS(Platform platform) {
            if (this.name == null) {
                return true;
            }
            if (this.name.equalsIgnoreCase((String)OS_NAMES.get((Object)platform.getOperatingSystem()))) {
                return true;
            }
            int classifierIndex = this.name.indexOf(45);
            if (classifierIndex > -1) {
                String arch = this.name.substring(classifierIndex + 1);
                String os = this.name.substring(0, classifierIndex);
                if (os.equalsIgnoreCase((String)OS_NAMES.get((Object)platform.getOperatingSystem()))) {
                    if (platform.getArchitecture().isArm()) {
                        String bit = platform.getArchitecture().is64Bit() ? "64" : "32";
                        return arch.equals("arm" + bit);
                    }
                    if (platform.getOperatingSystem().isWindows() && !platform.getArchitecture().is64Bit()) {
                        return arch.equals("x86");
                    }
                }
            }
            return false;
        }
    }

    public class Rule {
        public String action;
        public OS os;

        public boolean appliesToOS(Platform platform) {
            return this.os == null || this.os.isValidForOS(platform);
        }

        public boolean isAllowed() {
            return this.action.equals("allow");
        }
    }

    public class Downloads {
        public Download artifact;
        public Map<String, Download> classifiers;

        public Download classifier(String os) {
            return this.classifiers.get(os);
        }
    }

    public class Library {
        public Downloads downloads;
        public String name;
        public Map<String, String> natives;
        public List<Rule> rules;
        public Object extract;

        @Deprecated
        public Download getNative(Platform platform) {
            if (this.isMainValidForOS(platform)) {
                if (this.isValidForOS(platform) && this.classifierForOS(platform) != null) {
                    return this.classifierForOS(platform);
                }
                return this.downloads.artifact;
            }
            if (this.isValidForOS(platform)) {
                return this.classifierForOS(platform);
            }
            return null;
        }

        public boolean isValidForOS(Platform platform) {
            if (this.rules == null) {
                return true;
            }
            boolean valid = false;
            for (Rule rule : this.rules) {
                if (!rule.appliesToOS(platform)) continue;
                valid = rule.isAllowed();
            }
            return valid;
        }

        @Deprecated
        public boolean isMainValidForOS(Platform platform) {
            if (this.rules == null) {
                return false;
            }
            if (platform.getOperatingSystem().isWindows() && platform.getArchitecture().is64Bit() && this.name.endsWith("x86")) {
                return false;
            }
            boolean valid = false;
            for (Rule rule : this.rules) {
                if (rule.appliesToOS(platform)) {
                    valid = rule.isAllowed();
                    continue;
                }
                valid = false;
            }
            return valid;
        }

        public boolean hasNatives() {
            return this.natives != null;
        }

        public boolean hasNativesForOS(Platform platform) {
            if (!this.hasNatives()) {
                return false;
            }
            if (this.classifierForOS(platform) == null) {
                return false;
            }
            return this.isValidForOS(platform);
        }

        public Download classifierForOS(Platform platform) {
            Download armNative;
            if (this.natives == null) {
                return null;
            }
            String classifier = this.natives.get(OS_NAMES.get((Object)platform.getOperatingSystem()));
            if (classifier == null) {
                return null;
            }
            if (platform.getArchitecture().isArm()) {
                String bit = platform.getArchitecture().is64Bit() ? "64" : "32";
                Download armNative2 = this.downloads.classifier(classifier + "-arm" + bit);
                if (armNative2 != null) {
                    return armNative2;
                }
            } else if (platform.getOperatingSystem().isWindows() && !platform.getArchitecture().is64Bit() && (armNative = this.downloads.classifier(classifier + "-x86")) != null) {
                return armNative;
            }
            return this.downloads.classifier(classifier);
        }

        public Download artifact() {
            if (this.downloads == null) {
                return null;
            }
            return this.downloads.artifact;
        }
    }

    public class AssetIndex {
        public String id;
        public long totalSize;
        public String path;
        public String sha1;
        public long size;
        public String url;
    }
}

