/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.gui;

import com.cleanroommc.relauncher.CleanroomRelauncher;
import com.cleanroommc.relauncher.download.CleanroomRelease;
import com.cleanroommc.relauncher.gui.SupportingFrame;
import com.cleanroommc.relauncher.shade.javautils.JavaUtils;
import com.cleanroommc.relauncher.shade.javautils.api.JavaInstall;
import com.cleanroommc.relauncher.shade.javautils.spi.JavaLocator;
import com.cleanroommc.relauncher.util.Platform;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import net.minecraftforge.fml.cleanroomrelauncher.ExitVMBypass;

public class RelauncherGUI
extends JDialog {
    public CleanroomRelease selected;
    public String javaPath;
    public String javaArgs;
    private JFrame frame;

    private static void scaleComponent(Component component, float scale) {
        Insets margin;
        Font font;
        ImageIcon imageIcon;
        Image image;
        JLabel label;
        Icon icon;
        if (component instanceof JTextField || component instanceof JButton || component instanceof JComboBox) {
            Dimension size = component.getPreferredSize();
            component.setPreferredSize(new Dimension((int)((float)size.width * scale) + 10, (int)((float)size.height * scale)));
            component.setMaximumSize(new Dimension((int)((float)size.width * scale) + 10, (int)((float)size.height * scale)));
        } else if (component instanceof JLabel && (icon = (label = (JLabel)component).getIcon()) instanceof ImageIcon && (image = (imageIcon = (ImageIcon)icon).getImage()) != null) {
            Image scaledImage = image.getScaledInstance((int)((float)imageIcon.getIconWidth() * scale), (int)((float)imageIcon.getIconHeight() * scale), 4);
            label.setIcon(new ImageIcon(scaledImage));
        }
        if ((component instanceof JLabel || component instanceof JButton || component instanceof JTextField || component instanceof JComboBox) && (font = component.getFont()) != null) {
            component.setFont(font.deriveFont((float)font.getSize() * scale));
        }
        if (component instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)component;
            margin = button.getMargin();
            if (margin != null) {
                button.setMargin(new Insets((int)((float)margin.top * scale), (int)((float)margin.left * scale), (int)((float)margin.bottom * scale), (int)((float)margin.right * scale)));
            }
        } else if (component instanceof JTextField) {
            JTextField textField = (JTextField)component;
            margin = textField.getMargin();
            if (margin != null) {
                textField.setMargin(new Insets((int)((float)margin.top * scale), (int)((float)margin.left * scale), (int)((float)margin.bottom * scale), (int)((float)margin.right * scale)));
            }
        } else if (component instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)component;
            margin = comboBox.getInsets();
            if (margin != null) {
                comboBox.setBorder(BorderFactory.createEmptyBorder((int)((float)margin.top * scale), (int)((float)margin.left * scale), (int)((float)margin.bottom * scale), (int)((float)margin.right * scale)));
            }
        } else if (component instanceof JLabel) {
            label = (JLabel)component;
            margin = label.getInsets();
            if (margin != null) {
                label.setBorder(BorderFactory.createEmptyBorder((int)((float)margin.top * scale), (int)((float)margin.left * scale), (int)((float)margin.bottom * scale), (int)((float)margin.right * scale)));
            }
        } else if (component instanceof JPanel) {
            JPanel panel = (JPanel)component;
            Border existingBorder = panel.getBorder();
            Insets margin2 = existingBorder instanceof EmptyBorder ? ((EmptyBorder)existingBorder).getBorderInsets() : new Insets(0, 0, 0, 0);
            panel.setBorder(BorderFactory.createEmptyBorder((int)((float)margin2.top * scale), (int)((float)margin2.left * scale), (int)((float)margin2.bottom * scale), (int)((float)margin2.right * scale)));
        }
        component.revalidate();
        component.repaint();
        if (component instanceof Container) {
            for (Component child : ((Container)component).getComponents()) {
                RelauncherGUI.scaleComponent(child, scale);
            }
        }
    }

    public static RelauncherGUI show(List<CleanroomRelease> eligibleReleases, Consumer<RelauncherGUI> consumer) {
        ImageIcon imageIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(RelauncherGUI.class.getResource("/cleanroom-relauncher.png")));
        return new RelauncherGUI(new SupportingFrame("Cleanroom Relaunch Configuration", imageIcon), eligibleReleases, consumer);
    }

    private RelauncherGUI(final SupportingFrame frame, List<CleanroomRelease> eligibleReleases, Consumer<RelauncherGUI> consumer) {
        super(frame, frame.getTitle(), true);
        this.frame = frame;
        consumer.accept(this);
        this.setIconImage(frame.getIconImage());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RelauncherGUI.this.requestFocusInWindow();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RelauncherGUI.this.selected = null;
                frame.dispose();
                CleanroomRelauncher.LOGGER.info("No Cleanroom releases were selected, instance is dismissed.");
                ExitVMBypass.exit(0);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice screen = env.getDefaultScreenDevice();
        Rectangle rect = screen.getDefaultConfiguration().getBounds();
        int width = rect.width / 3;
        int height = (int)((float)width / 1.25f);
        int x = (rect.width - width) / 2;
        int y = (rect.height - height) / 2;
        this.setLocation(x, y);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JLabel cleanroomLogo = new JLabel(new ImageIcon(frame.getIconImage().getScaledInstance(80, 80, 4)));
        JPanel cleanroomPickerPanel = this.initializeCleanroomPicker(eligibleReleases);
        mainPanel.add(cleanroomPickerPanel);
        JPanel javaPickerPanel = this.initializeJavaPicker();
        mainPanel.add(javaPickerPanel);
        JPanel argsPanel = this.initializeArgsPanel();
        mainPanel.add(argsPanel);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)cleanroomLogo, "North");
        contentPanel.add((Component)mainPanel, "South");
        JPanel wrapper = new JPanel();
        wrapper.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        wrapper.add((Component)contentPanel, gbc);
        JPanel relaunchButtonPanel = this.initializeRelaunchPanel();
        this.add((Component)wrapper, "North");
        this.add((Component)relaunchButtonPanel, "South");
        float scale = (float)rect.width / 1463.0f;
        RelauncherGUI.scaleComponent(this, scale);
        this.pack();
        this.setSize(width, height);
        this.setVisible(true);
        this.setAutoRequestFocus(true);
    }

    private JPanel initializeCleanroomPicker(List<CleanroomRelease> eligibleReleases) {
        JPanel cleanroomPicker = new JPanel(new BorderLayout(5, 0));
        cleanroomPicker.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel select = new JPanel();
        select.setLayout(new BoxLayout(select, 1));
        cleanroomPicker.add(select);
        JLabel title = new JLabel("Select Cleanroom Version:");
        title.setAlignmentX(0.0f);
        select.add(title);
        select.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel dropdown = new JPanel(new BorderLayout(5, 5));
        dropdown.setAlignmentX(0.0f);
        select.add(dropdown);
        JComboBox<Object> releaseBox = new JComboBox<Object>();
        DefaultComboBoxModel<CleanroomRelease> releaseModel = new DefaultComboBoxModel<CleanroomRelease>();
        for (CleanroomRelease release : eligibleReleases) {
            releaseModel.addElement(release);
        }
        releaseBox.setModel(releaseModel);
        releaseBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof CleanroomRelease) {
                    this.setText(((CleanroomRelease)value).name);
                }
                return this;
            }
        });
        releaseBox.setSelectedItem(this.selected);
        releaseBox.setMaximumRowCount(5);
        releaseBox.addActionListener(e -> {
            this.selected = (CleanroomRelease)releaseBox.getSelectedItem();
        });
        dropdown.add(releaseBox, "Center");
        return cleanroomPicker;
    }

    private JPanel initializeJavaPicker() {
        JPanel javaPicker = new JPanel(new BorderLayout(5, 0));
        javaPicker.setBorder(BorderFactory.createEmptyBorder(20, 10, 0, 10));
        JPanel selectPanel = new JPanel(new BorderLayout(5, 5));
        selectPanel.setLayout(new BoxLayout(selectPanel, 1));
        JPanel subSelectPanel = new JPanel(new BorderLayout(5, 5));
        JLabel title = new JLabel("Select Java Executable:");
        JTextField text = new JTextField(100);
        text.setText(this.javaPath);
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BorderLayout(5, 0));
        northPanel.add((Component)title, "North");
        subSelectPanel.add((Component)northPanel, "North");
        subSelectPanel.add((Component)text, "Center");
        JButton browse = new JButton("Browse");
        subSelectPanel.add((Component)browse, "East");
        selectPanel.add(subSelectPanel);
        javaPicker.add(selectPanel);
        final JPanel versionDropdown = new JPanel(new BorderLayout(5, 0));
        versionDropdown.setAlignmentX(0.0f);
        JComboBox<Object> versionBox = new JComboBox<Object>();
        final DefaultComboBoxModel versionModel = new DefaultComboBoxModel();
        versionBox.setModel(versionModel);
        versionBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof JavaInstall) {
                    JavaInstall javaInstall = (JavaInstall)value;
                    this.setText(javaInstall.vendor() + " " + javaInstall.version());
                }
                return this;
            }
        });
        versionBox.setSelectedItem(null);
        versionBox.setMaximumRowCount(10);
        versionBox.addActionListener(e -> {
            if (versionBox.getSelectedItem() != null) {
                JavaInstall javaInstall = (JavaInstall)versionBox.getSelectedItem();
                this.javaPath = javaInstall.executable(true).getAbsolutePath();
                text.setText(this.javaPath);
            }
        });
        versionDropdown.add(versionBox, "Center");
        versionDropdown.setVisible(false);
        northPanel.add((Component)versionDropdown, "Center");
        JPanel options = new JPanel(new BorderLayout(5, 0));
        options.setLayout(new BoxLayout(options, 0));
        options.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        selectPanel.add(options);
        final JButton autoDetect = new JButton("Auto-Detect");
        JButton test = new JButton("Test");
        options.add(autoDetect);
        options.add(test);
        this.listenToTextFieldUpdate(text, t -> {
            this.javaPath = t.getText();
        });
        this.addTextBoxEffect(text);
        browse.addActionListener(e -> {
            File currentFile;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Find Java Executable");
            if (!text.getText().isEmpty() && (currentFile = new File(text.getText())).getParentFile() != null && currentFile.getParentFile().exists()) {
                fileChooser.setCurrentDirectory(currentFile.getParentFile());
            }
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (file.isFile()) {
                        return !Platform.CURRENT.getOperatingSystem().isWindows() || file.getName().endsWith(".exe");
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    return Platform.CURRENT.getOperatingSystem().isWindows() ? "Java Executable (*.exe)" : "Java Executable";
                }
            };
            fileChooser.setFileFilter(filter);
            fileChooser.setFileSelectionMode(0);
            int result = fileChooser.showOpenDialog(this);
            if (result == 0) {
                text.setText(fileChooser.getSelectedFile().getAbsolutePath());
            }
        });
        test.addActionListener(e -> {
            String javaPath = text.getText();
            if (javaPath.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Please select a Java executable first.", "No Java Selected", 2);
                return;
            }
            File javaFile = new File(javaPath);
            if (!javaFile.exists()) {
                JOptionPane.showMessageDialog(this, "The selected Java executable does not exist.", "Invalid Java Executable Path", 0);
                return;
            }
            JDialog testing = new JDialog(this, "Testing Java Executable", true);
            testing.setLocationRelativeTo(this);
            this.testJava();
        });
        autoDetect.addActionListener(e -> {
            final String original = autoDetect.getText();
            autoDetect.setText("Detecting");
            autoDetect.setEnabled(false);
            AtomicInteger dotI = new AtomicInteger(0);
            String[] dots = new String[]{".", "..", "..."};
            final Timer timer = new Timer(400, te -> {
                autoDetect.setText("Detecting" + dots[dotI.get()]);
                dotI.set((dotI.get() + 1) % dots.length);
            });
            timer.start();
            new SwingWorker<Void, Void>(){
                List javaInstalls = Collections.emptyList();

                @Override
                protected Void doInBackground() {
                    this.javaInstalls = JavaLocator.locators().parallelStream().map(JavaLocator::all).flatMap(Collection::stream).filter(javaInstall -> javaInstall.version().major() >= 21).distinct().sorted().collect(Collectors.toList());
                    return null;
                }

                @Override
                protected void done() {
                    timer.stop();
                    autoDetect.setText(original);
                    JOptionPane.showMessageDialog(RelauncherGUI.this, this.javaInstalls.size() + " Java 21+ Installs Found!", "Auto-Detection Finished", 1);
                    autoDetect.setEnabled(true);
                    if (!this.javaInstalls.isEmpty()) {
                        versionModel.removeAllElements();
                        for (JavaInstall install : this.javaInstalls) {
                            versionModel.addElement(install);
                        }
                        versionDropdown.setVisible(true);
                    }
                }
            }.execute();
        });
        return javaPicker;
    }

    private JPanel initializeArgsPanel() {
        JPanel argsPanel = new JPanel(new BorderLayout(0, 0));
        argsPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JLabel title = new JLabel("Add Java Arguments:");
        title.setAlignmentX(0.0f);
        JTextField text = new JTextField(100);
        text.setText(this.javaArgs);
        this.listenToTextFieldUpdate(text, t -> {
            this.javaArgs = t.getText();
        });
        this.addTextBoxEffect(text);
        argsPanel.add((Component)title, "North");
        argsPanel.add((Component)text, "Center");
        return argsPanel;
    }

    private JPanel initializeRelaunchPanel() {
        JPanel relaunchButtonPanel = new JPanel();
        JButton relaunchButton = new JButton("Relaunch with Cleanroom");
        relaunchButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        relaunchButton.addActionListener(e -> {
            if (this.selected == null) {
                JOptionPane.showMessageDialog(this, "Please select a Cleanroom version in order to relaunch.", "Cleanroom Release Not Selected", 0);
                return;
            }
            if (this.javaPath == null) {
                JOptionPane.showMessageDialog(this, "Please provide a valid Java Executable in order to relaunch.", "Java Executable Not Selected", 0);
                return;
            }
            Runnable test = this.testJavaAndReturn();
            if (test != null) {
                test.run();
                return;
            }
            this.frame.dispose();
        });
        relaunchButtonPanel.add(relaunchButton);
        return relaunchButtonPanel;
    }

    private void listenToTextFieldUpdate(final JTextField text, final Consumer<JTextField> textConsumer) {
        text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                textConsumer.accept(text);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                textConsumer.accept(text);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                textConsumer.accept(text);
            }
        });
    }

    private void addTextBoxEffect(final JTextField text) {
        text.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                text.setBorder(BorderFactory.createLineBorder(new Color(142, 177, 204)));
            }

            @Override
            public void focusLost(FocusEvent e) {
                text.setBorder(null);
            }
        });
    }

    private Runnable testJavaAndReturn() {
        try {
            JavaInstall javaInstall = JavaUtils.parseInstall(this.javaPath);
            if (javaInstall.version().major() < 21) {
                CleanroomRelauncher.LOGGER.fatal("Java 21+ needed, user specified Java {} instead", (Object)javaInstall.version());
                return () -> JOptionPane.showMessageDialog(this, "Java 21 is the minimum version for Cleanroom. Currently, Java " + javaInstall.version().major() + " is selected.", "Old Java Version", 0);
            }
            CleanroomRelauncher.LOGGER.info("Java {} specified from {}", (Object)javaInstall.version().major(), (Object)this.javaPath);
        }
        catch (IOException e) {
            CleanroomRelauncher.LOGGER.fatal("Failed to execute Java for testing", (Throwable)e);
            return () -> JOptionPane.showMessageDialog(this, "Failed to test Java (more information in console): " + e.getMessage(), "Java Test Failed", 0);
        }
        return null;
    }

    private void testJava() {
        try {
            JavaInstall javaInstall = JavaUtils.parseInstall(this.javaPath);
            if (javaInstall.version().major() < 21) {
                CleanroomRelauncher.LOGGER.fatal("Java 21+ needed, user specified Java {} instead", (Object)javaInstall.version());
                JOptionPane.showMessageDialog(this, "Java 21 is the minimum version for Cleanroom. Currently, Java " + javaInstall.version().major() + " is selected.", "Old Java Version", 0);
                return;
            }
            CleanroomRelauncher.LOGGER.info("Java {} specified from {}", (Object)javaInstall.version().major(), (Object)this.javaPath);
            JOptionPane.showMessageDialog(this, "Java executable is working correctly!", "Java Test Successful", 1);
        }
        catch (IOException e) {
            CleanroomRelauncher.LOGGER.fatal("Failed to execute Java for testing", (Throwable)e);
            JOptionPane.showMessageDialog(this, "Failed to test Java (more information in console): " + e.getMessage(), "Java Test Failed", 0);
        }
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

