/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.shade.javautils;

import com.cleanroommc.relauncher.shade.javautils.JavaInstallImpl;
import com.cleanroommc.relauncher.shade.javautils.api.JavaInstall;
import com.cleanroommc.relauncher.shade.javautils.checker.JavaChecker;
import com.cleanroommc.relauncher.shade.platformutils.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;

public final class JavaUtils {
    public static File currentJarLocation() {
        return JavaUtils.jarLocationOf(JavaUtils.class);
    }

    public static File jarLocationOf(Class<?> clazz) {
        String url = null;
        try {
            url = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
        }
        catch (NullPointerException | SecurityException runtimeException) {
            // empty catch block
        }
        if (url == null) {
            String suffix;
            URL resource = clazz.getResource(clazz.getSimpleName() + ".class");
            if (resource == null) {
                throw new RuntimeException("Could not find resource of " + clazz.getSimpleName() + ".class!");
            }
            String resourceString = resource.toString();
            if (!resourceString.endsWith(suffix = clazz.getCanonicalName().replace('.', '/') + ".class")) {
                throw new RuntimeException("Malformed URL for " + clazz.getSimpleName() + ".class: " + url);
            }
            url = resourceString.substring(0, resourceString.length() - suffix.length());
        }
        if (url.startsWith("jar:")) {
            url = url.substring(4, url.indexOf("!/"));
        }
        try {
            if (Platform.current().isWindows() && url.matches("file:[A-Za-z]:.*")) {
                url = "file:/" + url.substring(5);
            }
            return new File(new URL(url).toURI());
        }
        catch (MalformedURLException | URISyntaxException e) {
            if (url.startsWith("file:")) {
                url = url.substring(5);
                return new File(url);
            }
            throw new IllegalArgumentException("Invalid URL: " + url, e);
        }
    }

    public static JavaInstall parseInstall(File location) throws IOException {
        return JavaUtils.parseInstall(location.getAbsolutePath());
    }

    public static JavaInstall parseInstall(String location) throws IOException {
        String executableLocation;
        String rootLocation;
        ArrayList<String> arguments = new ArrayList<String>();
        ProcessBuilder processBuilder = new ProcessBuilder(arguments);
        File workingJar = JavaUtils.jarLocationOf(JavaChecker.class);
        File workingDir = workingJar.getParentFile();
        processBuilder.directory(workingDir);
        boolean isWindows = Platform.current().isWindows();
        if (location.endsWith("bin")) {
            rootLocation = location.substring(0, location.length() - "/bin".length());
            executableLocation = location + (isWindows ? "\\javaw.exe" : "/javaw");
        } else if (!location.endsWith(isWindows ? "javaw.exe" : "javaw")) {
            rootLocation = location;
            executableLocation = location + (isWindows ? "\\bin\\javaw.exe" : "/bin/javaw");
        } else {
            File fileLocation = new File(location);
            rootLocation = fileLocation.getParentFile().getParentFile().getAbsolutePath();
            executableLocation = location;
        }
        File root = new File(rootLocation);
        if (!new File(executableLocation).exists()) {
            throw new IOException("Invalid location for a java install: " + location);
        }
        arguments.add(executableLocation);
        arguments.add("-cp");
        arguments.add(workingJar.getName());
        arguments.add(JavaChecker.class.getName());
        ArrayList<String> output = new ArrayList<String>();
        try {
            String inLine;
            Process process = processBuilder.start();
            BufferedReader inReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((inLine = inReader.readLine()) != null) {
                output.add(inLine);
            }
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw new IOException("Unable to parse install", e);
        }
        return JavaInstallImpl.of(root, (String)output.get(0), (String)output.get(1));
    }

    private JavaUtils() {
    }
}

