/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.shade.platformutils.windows;

import com.cleanroommc.relauncher.shade.platformutils.windows.HKey;
import com.cleanroommc.relauncher.shade.platformutils.windows.QueryParameter;
import com.cleanroommc.relauncher.shade.platformutils.windows.QueryResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class WindowsRegistry {
    public static QueryResult query(HKey hKey, String key, QueryParameter ... parameters) {
        return WindowsRegistry.buildAndParseQuery(hKey, key, parameters);
    }

    private static QueryResult buildAndParseQuery(HKey hKey, String key, QueryParameter ... parameters) {
        List<String> results;
        try {
            results = WindowsRegistry.buildQuery(hKey, key, parameters);
        }
        catch (IOException e) {
            return QueryResult.error(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Unable to query!", e);
        }
        ArrayList<QueryResult.Entry> entries = new ArrayList<QueryResult.Entry>();
        if (results.isEmpty() || results.stream().map(String::trim).allMatch(String::isEmpty)) {
            return QueryResult.success(Collections.emptyList());
        }
        String currentKey = null;
        for (String result : results) {
            String[] split = result.split(" {4}");
            if (split.length == 0) continue;
            String firstSplit = split[0];
            if (firstSplit.startsWith(hKey.toString())) {
                currentKey = split[0].substring(split[0].indexOf(92) + 1);
                continue;
            }
            if (!firstSplit.isEmpty() || split.length != 4) continue;
            entries.add(QueryResult.parse(hKey, currentKey, split));
        }
        return QueryResult.success(entries);
    }

    private static List<String> buildQuery(HKey hKey, String key, QueryParameter ... parameters) throws IOException, InterruptedException {
        String str;
        key = WindowsRegistry.normalizeKey(key);
        String compiledParameters = Arrays.stream(parameters).map(Object::toString).collect(Collectors.joining(" "));
        String query = String.format("reg query \"%s\\%s\" %s", hKey.getAbbreviation(), key, compiledParameters);
        Process process = Runtime.getRuntime().exec(query);
        BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        process.waitFor();
        ArrayList<String> result = new ArrayList<String>();
        while ((str = err.readLine()) != null) {
            result.add(str);
        }
        if (!result.isEmpty()) {
            throw new IOException(String.join((CharSequence)"\n", result));
        }
        while ((str = in.readLine()) != null) {
            result.add(str);
        }
        return result;
    }

    private static String normalizeKey(String key) {
        return key.replace("/", "\\");
    }

    private WindowsRegistry() {
    }
}

