/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.util;

public final class Platform {
    public static final Platform CURRENT = new Platform();
    private final OperatingSystem operatingSystem = OperatingSystem.access$000();
    private final Architecture architecture = Architecture.access$100();

    public static String fixCommandLine(String cmdlineArg) {
        return CURRENT.getOperatingSystem().isWindows() ? cmdlineArg.replace("\"", "\\\"") : cmdlineArg;
    }

    private Platform() {
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    public static final class Architecture {
        private final boolean is64Bit;
        private final boolean isArm;

        private static Architecture determine() {
            String arch = System.getProperty("os.arch");
            boolean is64Bit = arch.contains("64") || arch.startsWith("armv8");
            boolean isArm = arch.startsWith("arm") || arch.startsWith("aarch64");
            return new Architecture(is64Bit, isArm);
        }

        private Architecture(boolean is64Bit, boolean isArm) {
            this.is64Bit = is64Bit;
            this.isArm = isArm;
        }

        public boolean is64Bit() {
            return this.is64Bit;
        }

        public boolean isArm() {
            return this.isArm;
        }

        static /* synthetic */ Architecture access$100() {
            return Architecture.determine();
        }
    }

    public static enum OperatingSystem {
        WINDOWS,
        MAC_OS,
        LINUX;


        private static OperatingSystem determine() {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.contains("win")) {
                return WINDOWS;
            }
            if (osName.contains("mac")) {
                return MAC_OS;
            }
            return LINUX;
        }

        public boolean isWindows() {
            return this == WINDOWS;
        }

        public boolean isMacOS() {
            return this == MAC_OS;
        }

        public boolean isLinux() {
            return this == LINUX;
        }

        static /* synthetic */ OperatingSystem access$000() {
            return OperatingSystem.determine();
        }
    }
}

