/*
 * Decompiled with CFR 0.152.
 */
package org.skydream.sphinxriddle;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.skydream.sphinxriddle.Config;
import org.skydream.sphinxriddle.QuizCommands;
import org.skydream.sphinxriddle.QuizManager;
import org.slf4j.Logger;

@Mod(value="sphinxriddle")
public class SphinxRiddle {
    public static final String MODID = "sphinxriddle";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static QuizManager quizManager;

    public SphinxRiddle(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onClientSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("SphinxRiddle mod initialized");
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        LOGGER.info("SphinxRiddle client setup complete");
        event.enqueueWork(() -> LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName()));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        try {
            quizManager = new QuizManager(event.getServer());
            quizManager.loadConfig();
            quizManager.startAutoQuestionTimer();
            quizManager.initializeScoreboard();
            LOGGER.info("SphinxRiddle started successfully");
        }
        catch (Exception e) {
            LOGGER.error("Failed to start SphinxRiddle", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        if (quizManager != null) {
            quizManager.stopAutoQuestionTimer();
        }
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        QuizCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    @SubscribeEvent
    public void onServerChat(ServerChatEvent event) {
        if (quizManager != null) {
            quizManager.handlePlayerAnswer(event.getPlayer(), event.getRawText());
        }
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        if (quizManager != null) {
            quizManager.tick();
        }
    }

    public static QuizManager getQuizManager() {
        return quizManager;
    }
}

