/*
 * Decompiled with CFR 0.152.
 */
package org.skydream.sphinxriddle;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.skydream.sphinxriddle.Question;
import org.skydream.sphinxriddle.QuizManager;
import org.skydream.sphinxriddle.Reward;
import org.skydream.sphinxriddle.SphinxRiddle;

public class QuizCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        System.out.println("QuizCommands: \u5f00\u59cb\u6ce8\u518c\u547d\u4ee4");
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"sr").executes(ctx -> {
            QuizCommands.showHelp((CommandSourceStack)ctx.getSource());
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"sr").then(((LiteralArgumentBuilder)Commands.literal((String)"question").requires(source -> source.hasPermission(0))).executes(ctx -> QuizCommands.askNewQuestion((CommandSourceStack)ctx.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"sr").then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(source -> source.hasPermission(2))).executes(ctx -> QuizCommands.reloadConfig((CommandSourceStack)ctx.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"sr").then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"question").then(Commands.argument((String)"question", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"answer", (ArgumentType)StringArgumentType.string()).executes(ctx -> QuizCommands.addQuestion((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"question"), StringArgumentType.getString((CommandContext)ctx, (String)"answer"))))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"sr").then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"reward").then(Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)context)).then(Commands.argument((String)"maxAmount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            ItemStack stack = ItemArgument.getItem((CommandContext)ctx, (String)"item").createItemStack(1, false);
            Item item = stack.getItem();
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            return QuizCommands.addReward((CommandSourceStack)ctx.getSource(), id.toString(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxAmount"));
        }))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"sr").then(((LiteralArgumentBuilder)Commands.literal((String)"list").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"question").executes(ctx -> QuizCommands.listQuestions((CommandSourceStack)ctx.getSource())))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"sr").then(((LiteralArgumentBuilder)Commands.literal((String)"list").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"reward").executes(ctx -> QuizCommands.listRewards((CommandSourceStack)ctx.getSource())))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"sr").then(((LiteralArgumentBuilder)Commands.literal((String)"list").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"ranking").executes(ctx -> QuizCommands.listRanking((CommandSourceStack)ctx.getSource())))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"sr").then(((LiteralArgumentBuilder)Commands.literal((String)"reset").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"ranking").executes(ctx -> QuizCommands.resetRanking((CommandSourceStack)ctx.getSource())))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"sr").then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"question").then(Commands.argument((String)"question", (ArgumentType)StringArgumentType.string()).executes(ctx -> QuizCommands.removeQuestion((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"question")))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"sr").then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"reward").then(Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)context)).executes(ctx -> {
            ItemStack stack = ItemArgument.getItem((CommandContext)ctx, (String)"item").createItemStack(1, false);
            Item item = stack.getItem();
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            return QuizCommands.removeReward((CommandSourceStack)ctx.getSource(), id.toString());
        })))));
        System.out.println("QuizCommands: \u6240\u6709\u547d\u4ee4\u6ce8\u518c\u5b8c\u6210");
    }

    private static void showHelp(CommandSourceStack source) {
        source.sendSuccess(() -> Component.literal((String)"\u00a76=== SphinxRiddle \u547d\u4ee4\u5e2e\u52a9 ==="), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a7a/sr question \u00a77- \u53d1\u8d77\u65b0\u95ee\u9898"), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a7e/sr add reward <\u7269\u54c1> <\u6570\u91cf> \u00a77- \u6dfb\u52a0\u5956\u52b1"), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a7e/sr remove reward <\u7269\u54c1> \u00a77- \u79fb\u9664\u5956\u52b1"), false);
    }

    private static int reloadConfig(CommandSourceStack source) {
        QuizManager manager = SphinxRiddle.getQuizManager();
        if (manager != null) {
            manager.reload();
            source.sendSuccess(() -> Component.literal((String)"\u00a7a\u5df2\u91cd\u8f7d\u914d\u7f6e"), true);
            return 1;
        }
        source.sendSuccess(() -> Component.literal((String)"\u00a7cSphinxRiddle \u672a\u521d\u59cb\u5316"), true);
        return 0;
    }

    private static int addQuestion(CommandSourceStack source, String question, String answer) {
        QuizManager manager = SphinxRiddle.getQuizManager();
        if (manager != null) {
            manager.addQuestion(new Question(question, answer));
            source.sendSuccess(() -> Component.literal((String)("\u00a7a\u6dfb\u52a0\u95ee\u9898: " + question)), true);
            return 1;
        }
        return 0;
    }

    private static int addReward(CommandSourceStack source, String itemId, int maxAmount) {
        QuizManager manager = SphinxRiddle.getQuizManager();
        if (manager != null) {
            manager.addReward(new Reward(itemId, maxAmount));
            source.sendSuccess(() -> Component.literal((String)("\u00a7a\u6dfb\u52a0\u5956\u52b1: " + itemId + " *" + maxAmount)), true);
            return 1;
        }
        return 0;
    }

    private static int askNewQuestion(CommandSourceStack source) {
        QuizManager manager = SphinxRiddle.getQuizManager();
        if (manager != null) {
            manager.askRandomQuestion();
            source.sendSuccess(() -> Component.literal((String)"\u00a7a\u5df2\u53d1\u5e03\u65b0\u95ee\u9898"), true);
            return 1;
        }
        return 0;
    }

    private static int listQuestions(CommandSourceStack source) {
        QuizManager manager = SphinxRiddle.getQuizManager();
        if (manager != null) {
            source.sendSuccess(() -> Component.literal((String)"\u00a76=== \u95ee\u9898\u5217\u8868 ==="), false);
            int i = 1;
            for (Question q : manager.getQuestions()) {
                int idx = i++;
                source.sendSuccess(() -> Component.literal((String)("\u00a7e" + idx + ". \u00a7f" + q.getQuestion() + " \u00a77-> \u00a7a" + q.getAnswer())), false);
            }
            return 1;
        }
        return 0;
    }

    private static int listRewards(CommandSourceStack source) {
        QuizManager manager = SphinxRiddle.getQuizManager();
        if (manager != null) {
            source.sendSuccess(() -> Component.literal((String)"\u00a76=== \u5956\u52b1\u5217\u8868 ==="), false);
            int i = 1;
            for (Reward r : manager.getRewards()) {
                int idx = i++;
                source.sendSuccess(() -> Component.literal((String)("\u00a7e" + idx + ". \u00a7f" + r.getItemId() + " \u00a77(\u6700\u591a: \u00a7a" + r.getMaxAmount() + "\u00a77)")), false);
            }
            return 1;
        }
        return 0;
    }

    private static int listRanking(CommandSourceStack source) {
        QuizManager manager = SphinxRiddle.getQuizManager();
        if (manager != null) {
            Map<String, Integer> rankings = manager.getScoreboard().getRankings();
            source.sendSuccess(() -> Component.literal((String)"\u00a76=== \u6392\u884c\u699c ==="), false);
            if (rankings.isEmpty()) {
                source.sendSuccess(() -> Component.literal((String)"\u00a77\u6682\u65e0\u6570\u636e"), false);
            } else {
                int rank = 1;
                for (Map.Entry<String, Integer> entry : rankings.entrySet()) {
                    String color = rank == 1 ? "\u00a76" : (rank == 2 ? "\u00a77" : (rank == 3 ? "\u00a7c" : "\u00a7f"));
                    int finalRank = rank++;
                    source.sendSuccess(() -> Component.literal((String)(color + finalRank + ". \u00a7f" + (String)entry.getKey() + " \u00a77- \u00a7a" + String.valueOf(entry.getValue()) + " \u5206")), false);
                    if (rank <= 10) continue;
                    break;
                }
            }
            return 1;
        }
        source.sendSuccess(() -> Component.literal((String)"\u00a7cSphinxRiddle \u672a\u521d\u59cb\u5316"), true);
        return 0;
    }

    private static int resetRanking(CommandSourceStack source) {
        QuizManager manager = SphinxRiddle.getQuizManager();
        if (manager != null) {
            manager.getScoreboard().resetScoreboard();
            manager.updateScoreboardForAllPlayers();
            source.sendSuccess(() -> Component.literal((String)"\u00a7a\u6392\u884c\u699c\u5df2\u91cd\u7f6e"), true);
            return 1;
        }
        source.sendSuccess(() -> Component.literal((String)"\u00a7cSphinxRiddle \u672a\u521d\u59cb\u5316"), true);
        return 0;
    }

    private static int removeQuestion(CommandSourceStack source, String text) {
        QuizManager manager = SphinxRiddle.getQuizManager();
        if (manager != null) {
            manager.removeQuestion(text);
            source.sendSuccess(() -> Component.literal((String)("\u00a7a\u5df2\u79fb\u9664\u95ee\u9898: " + text)), true);
            return 1;
        }
        return 0;
    }

    private static int removeReward(CommandSourceStack source, String itemId) {
        QuizManager manager = SphinxRiddle.getQuizManager();
        if (manager != null) {
            manager.removeReward(itemId);
            source.sendSuccess(() -> Component.literal((String)("\u00a7a\u5df2\u79fb\u9664\u5956\u52b1: " + itemId)), true);
            return 1;
        }
        return 0;
    }
}

