/*
 * Decompiled with CFR 0.152.
 */
package org.skydream.sphinxriddle;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class QuizScoreboard {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final File scoreboardFile;
    private Map<String, Integer> playerScores;

    public QuizScoreboard(File configDir) {
        this.scoreboardFile = new File(configDir, "scoreboard.json");
        this.playerScores = new HashMap<String, Integer>();
        this.loadScoreboard();
    }

    public void loadScoreboard() {
        if (!this.scoreboardFile.exists()) {
            this.playerScores = new HashMap<String, Integer>();
            return;
        }
        try (FileReader reader = new FileReader(this.scoreboardFile);){
            PlayerScore[] scores = (PlayerScore[])GSON.fromJson((Reader)reader, PlayerScore[].class);
            this.playerScores = new HashMap<String, Integer>();
            for (PlayerScore score : scores) {
                this.playerScores.put(score.getPlayerName(), score.getScore());
            }
        }
        catch (IOException e) {
            this.playerScores = new HashMap<String, Integer>();
        }
    }

    public void saveScoreboard() {
        try (FileWriter writer = new FileWriter(this.scoreboardFile);){
            ArrayList<PlayerScore> scores = new ArrayList<PlayerScore>();
            for (Map.Entry<String, Integer> entry : this.playerScores.entrySet()) {
                scores.add(new PlayerScore(entry.getKey(), entry.getValue()));
            }
            GSON.toJson(scores, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addScore(String playerName, int points) {
        int currentScore = this.playerScores.getOrDefault(playerName, 0);
        this.playerScores.put(playerName, currentScore + points);
        this.saveScoreboard();
    }

    public void resetScoreboard() {
        this.playerScores.clear();
        this.saveScoreboard();
    }

    public Map<String, Integer> getRankings() {
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(this.playerScores.entrySet());
        list.sort((a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue()));
        LinkedHashMap<String, Integer> sortedScores = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : list) {
            sortedScores.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return sortedScores;
    }

    public int getPlayerScore(String playerName) {
        return this.playerScores.getOrDefault(playerName, 0);
    }

    public void initializeScoreboard(MinecraftServer server) {
        this.createScoreboard(server);
    }

    public void updateScoreboardDisplay(MinecraftServer server) {
        this.createScoreboard(server);
    }

    private void createScoreboard(MinecraftServer server) {
        String objectiveName;
        ServerScoreboard scoreboard = server.getScoreboard();
        Objective oldObj = scoreboard.getObjective(objectiveName = "sphinxriddle_ranking");
        if (oldObj != null) {
            scoreboard.removeObjective(oldObj);
        }
        Objective objective = scoreboard.addObjective(objectiveName, ObjectiveCriteria.DUMMY, (Component)Component.literal((String)"\u00a76\u00a7l\u95ee\u7b54\u7ade\u8d5b\u6392\u884c\u699c"), ObjectiveCriteria.RenderType.INTEGER, false, null);
        scoreboard.setDisplayObjective(DisplaySlot.SIDEBAR, objective);
        int rank = 1;
        for (Map.Entry<String, Integer> entry : this.getRankings().entrySet()) {
            if (rank > 15) break;
            String displayName = this.getRankDisplayName(rank, entry.getKey());
            ScoreHolder holder = ScoreHolder.forNameOnly((String)displayName);
            scoreboard.getOrCreatePlayerScore(holder, objective).set(entry.getValue().intValue());
            ++rank;
        }
    }

    private String getRankDisplayName(int rank, String playerName) {
        String color = switch (rank) {
            case 1 -> "\u00a76\u00a7l";
            case 2 -> "\u00a7b\u00a7l";
            case 3 -> "\u00a7a\u00a7l";
            case 4 -> "\u00a7e";
            case 5 -> "\u00a7d";
            default -> "\u00a77";
        };
        return color + rank + ". " + playerName;
    }

    private static class PlayerScore {
        private String playerName;
        private int score;

        public PlayerScore() {
        }

        public PlayerScore(String playerName, int score) {
            this.playerName = playerName;
            this.score = score;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public int getScore() {
            return this.score;
        }

        public void setPlayerName(String playerName) {
            this.playerName = playerName;
        }

        public void setScore(int score) {
            this.score = score;
        }
    }
}

