/*
 * Decompiled with CFR 0.152.
 */
package com.prizowo.enchantmentlevelbreak.mixin;

import com.prizowo.enchantmentlevelbreak.config.Config;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilMenuMixin
extends ItemCombinerMenu {
    @Shadow
    private int f_39000_;
    @Shadow
    private final DataSlot f_39002_ = DataSlot.m_39401_();
    @Unique
    private static final ThreadLocal<Boolean> IS_PROCESSING = ThreadLocal.withInitial(() -> false);

    protected AnvilMenuMixin(MenuType<?> menuType, int containerId, Inventory inventory, ContainerLevelAccess access) {
        super(menuType, containerId, inventory, access);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"createResult"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCreateResult(CallbackInfo ci) {
        if (IS_PROCESSING.get().booleanValue()) {
            return;
        }
        try {
            IS_PROCESSING.set(true);
            ItemStack left = this.f_39769_.m_8020_(0);
            ItemStack right = this.f_39769_.m_8020_(1);
            if (!left.m_41619_() && !right.m_41619_()) {
                this.handleAnvilOperation(left, right, ci);
            }
        }
        finally {
            IS_PROCESSING.set(false);
        }
    }

    @Unique
    private void handleAnvilOperation(ItemStack left, ItemStack right, CallbackInfo ci) {
        Map leftEnchants = EnchantmentHelper.m_44831_((ItemStack)left);
        Map rightEnchants = EnchantmentHelper.m_44831_((ItemStack)right);
        if (left.m_41720_() == right.m_41720_()) {
            if (!leftEnchants.isEmpty() || !rightEnchants.isEmpty()) {
                this.handleEnchantmentMerge(left, leftEnchants, rightEnchants, true, ci);
            }
            return;
        }
        if (!rightEnchants.isEmpty() && this.isEnchantedBook(right)) {
            this.handleEnchantmentMerge(left, leftEnchants, rightEnchants, false, ci);
        }
    }

    @Unique
    private boolean isEnchantedBook(ItemStack stack) {
        return stack.m_41720_() == Items.f_42690_;
    }

    @Unique
    private void handleEnchantmentMerge(ItemStack target, Map<Enchantment, Integer> leftEnchants, Map<Enchantment, Integer> rightEnchants, boolean isSameItemMerge, CallbackInfo ci) {
        HashMap<Enchantment, Integer> resultEnchants = new HashMap<Enchantment, Integer>(leftEnchants);
        int totalCost = 0;
        boolean anyEnchantmentApplied = false;
        for (Map.Entry<Enchantment, Integer> entry : rightEnchants.entrySet()) {
            Enchantment enchantment = entry.getKey();
            int rightLevel = entry.getValue();
            boolean canApply = isSameItemMerge || Config.allowAnyEnchantment || enchantment.m_6081_(target);
            if (!canApply) continue;
            int leftLevel = resultEnchants.getOrDefault(enchantment, 0);
            int newLevel = this.calculateNewLevel(leftLevel, rightLevel);
            newLevel = Math.min(newLevel, Config.maxEnchantmentLevel);
            resultEnchants.put(enchantment, newLevel);
            totalCost += newLevel;
            anyEnchantmentApplied = true;
        }
        if (anyEnchantmentApplied) {
            this.applyResult(target, resultEnchants, totalCost);
            ci.cancel();
        }
    }

    @Unique
    private int calculateNewLevel(int leftLevel, int rightLevel) {
        if (Config.allowLevelStacking) {
            return leftLevel + rightLevel;
        }
        if (Config.allowVanillaLevelStacking && leftLevel == rightLevel) {
            return leftLevel + 1;
        }
        return Math.max(leftLevel, rightLevel);
    }

    @Unique
    private void applyResult(ItemStack target, Map<Enchantment, Integer> enchantments, int totalCost) {
        ItemStack result = target.m_41777_();
        EnchantmentHelper.m_44865_(enchantments, (ItemStack)result);
        this.f_39768_.m_6836_(0, result);
        this.f_39000_ = Math.min(totalCost, 50);
        this.f_39002_.m_6422_(this.f_39000_);
    }
}

