/*
 * Decompiled with CFR 0.152.
 */
package com.prizowo.enchantmentlevelbreak.mixin;

import com.prizowo.enchantmentlevelbreak.config.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.enchantment.Enchantment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Enchantment.class})
public class EnchantmentHelper {
    @Inject(method={"getFullname"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyEnchantmentName(int level, CallbackInfoReturnable<Component> cir) {
        Enchantment enchantment = (Enchantment)this;
        ChatFormatting nameColor = enchantment.m_6589_() ? ChatFormatting.RED : ChatFormatting.GRAY;
        MutableComponent name = Component.m_237115_((String)enchantment.m_44704_()).m_130940_(nameColor);
        if (level != 1) {
            String levelText = level > 10000 ? String.valueOf(level) : (Config.useRomanNumerals ? EnchantmentHelper.enchantmentLevelBreak$intToRoman(level) : String.valueOf(level));
            name.m_130946_(" ").m_7220_((Component)Component.m_237113_((String)levelText).m_130940_(nameColor));
        }
        cir.setReturnValue((Object)name);
    }

    @Unique
    private static String enchantmentLevelBreak$intToRoman(int num) {
        if (num <= 0) {
            return "0";
        }
        int[] values = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] symbols = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        StringBuilder roman = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            while (num >= values[i]) {
                roman.append(symbols[i]);
                num -= values[i];
            }
        }
        return roman.toString();
    }
}

