/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.enchantmentlevelbreak.mixin;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import net.prizowo.enchantmentlevelbreak.config.ModConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1706.class})
public abstract class AnvilMenuMixin
extends class_4861 {
    @Shadow
    private int field_7776;
    @Shadow
    private final class_3915 field_7770 = class_3915.method_17403();

    protected AnvilMenuMixin(class_3917<?> type, int syncId, class_1661 playerInventory, class_3914 context) {
        super(type, syncId, playerInventory, context);
    }

    @Inject(method={"updateResult"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUpdateResult(CallbackInfo ci) {
        class_1799 left = this.field_22480.method_5438(0);
        class_1799 right = this.field_22480.method_5438(1);
        if (!left.method_7960() && !right.method_7960()) {
            this.handleAnvilOperation(left, right, ci);
        }
    }

    @Unique
    private void handleAnvilOperation(class_1799 left, class_1799 right, CallbackInfo ci) {
        Map leftEnchants = class_1890.method_8222((class_1799)left);
        Map rightEnchants = class_1890.method_8222((class_1799)right);
        if (left.method_7909() == right.method_7909()) {
            if (!leftEnchants.isEmpty() || !rightEnchants.isEmpty()) {
                this.handleEnchantmentMerge(left, leftEnchants, rightEnchants, true, ci);
            }
            return;
        }
        if (!rightEnchants.isEmpty() && this.isEnchantedBook(right)) {
            this.handleEnchantmentMerge(left, leftEnchants, rightEnchants, false, ci);
        }
    }

    @Unique
    private boolean isEnchantedBook(class_1799 stack) {
        return stack.method_31574(class_1802.field_8598);
    }

    @Unique
    private void handleEnchantmentMerge(class_1799 target, Map<class_1887, Integer> leftEnchants, Map<class_1887, Integer> rightEnchants, boolean isSameItemMerge, CallbackInfo ci) {
        if (!(ModConfig.getInstance().isAllowLevelStacking() || ModConfig.getInstance().isAllowVanillaLevelStacking() || ModConfig.getInstance().isAllowAnyEnchantment())) {
            return;
        }
        HashMap<class_1887, Integer> resultEnchants = new HashMap<class_1887, Integer>(leftEnchants);
        int totalCost = 0;
        boolean anyEnchantmentApplied = false;
        for (Map.Entry<class_1887, Integer> entry : rightEnchants.entrySet()) {
            class_1887 enchantment = entry.getKey();
            int rightLevel = entry.getValue();
            boolean canApply = isSameItemMerge || ModConfig.getInstance().isAllowAnyEnchantment() || enchantment.method_8192(target);
            if (!canApply) continue;
            int leftLevel = resultEnchants.getOrDefault(enchantment, 0);
            int newLevel = this.calculateNewLevel(leftLevel, rightLevel);
            newLevel = Math.min(newLevel, ModConfig.getInstance().getMaxEnchantmentLevel());
            resultEnchants.put(enchantment, newLevel);
            totalCost += newLevel;
            anyEnchantmentApplied = true;
        }
        if (anyEnchantmentApplied) {
            this.applyResult(target, resultEnchants, totalCost);
            ci.cancel();
        }
    }

    @Unique
    private int calculateNewLevel(int leftLevel, int rightLevel) {
        if (ModConfig.getInstance().isAllowLevelStacking()) {
            return leftLevel + rightLevel;
        }
        if (ModConfig.getInstance().isAllowVanillaLevelStacking() && leftLevel == rightLevel) {
            return leftLevel + 1;
        }
        return Math.max(leftLevel, rightLevel);
    }

    @Unique
    private void applyResult(class_1799 target, Map<class_1887, Integer> enchantments, int totalCost) {
        class_1799 result = target.method_7972();
        class_1890.method_8214(enchantments, (class_1799)result);
        this.field_22479.method_5447(0, result);
        this.field_7776 = Math.min(totalCost, 50);
        this.field_7770.method_17404(this.field_7776);
    }
}

