/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.enchantmentlevelbreak.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.HashMap;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class CEnchantCommand {
    private static final String TRANSLATION_PREFIX = "command.enchantmentlevelbreak.cenchant.";

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"cenchant").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"enchantment", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9264(class_2378.field_11160.method_10235().stream().map(class_2960::toString), (SuggestionsBuilder)builder)).executes(context -> CEnchantCommand.enchantItem((CommandContext<class_2168>)context, 1))).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> CEnchantCommand.enchantItem((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"level"))))));
    }

    private static int enchantItem(CommandContext<class_2168> context, int level) throws CommandSyntaxException {
        class_1887 enchantment;
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        class_1799 itemStack = player.method_6047();
        if (itemStack.method_7960()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.enchantmentlevelbreak.cenchant.no_item"));
            return 0;
        }
        if (level > Integer.MAX_VALUE || level < 1) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.enchantmentlevelbreak.cenchant.level_too_high", (Object[])new Object[]{Integer.MAX_VALUE}));
            return 0;
        }
        String enchantmentInput = StringArgumentType.getString(context, (String)"enchantment");
        String[] parts = enchantmentInput.split("\\s+", 2);
        String enchantmentName = parts[0];
        if (parts.length > 1) {
            try {
                long longLevel = Long.parseLong(parts[1]);
                if (longLevel > Integer.MAX_VALUE) {
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.enchantmentlevelbreak.cenchant.level_too_high", (Object[])new Object[]{Integer.MAX_VALUE}));
                    return 0;
                }
                level = (int)longLevel;
            }
            catch (NumberFormatException longLevel) {
                // empty catch block
            }
        }
        if ((enchantment = CEnchantCommand.getEnchantment(enchantmentName)) == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.enchantmentlevelbreak.cenchant.invalid_enchantment", (Object[])new Object[]{enchantmentName}));
            return 0;
        }
        HashMap<class_1887, Integer> enchantments = new HashMap<class_1887, Integer>(class_1890.method_8222((class_1799)itemStack));
        enchantments.put(enchantment, level);
        class_1890.method_8214(enchantments, (class_1799)itemStack);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43469((String)"command.enchantmentlevelbreak.cenchant.success", (Object[])new Object[]{enchantment.method_8179(level)}), true);
        return 1;
    }

    private static class_1887 getEnchantment(String name) {
        class_2960 enchantmentId = name.contains(":") ? new class_2960(name) : new class_2960("minecraft", name);
        return (class_1887)class_2378.field_11160.method_10223(enchantmentId);
    }
}

