/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.enchantmentlevelbreak.mixin;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3048;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3048.class})
public class CommandMixin {
    @Shadow
    @Final
    private static DynamicCommandExceptionType field_13633;
    @Shadow
    @Final
    private static DynamicCommandExceptionType field_13631;
    @Shadow
    @Final
    private static DynamicCommandExceptionType field_13629;
    @Shadow
    @Final
    private static SimpleCommandExceptionType field_13630;

    @Inject(method={"execute"}, at={@At(value="HEAD")}, cancellable=true, order=-999)
    private static void execute(class_2168 source, Collection<? extends class_1297> targets, class_1887 enchantment, int level, CallbackInfoReturnable<Integer> cir) throws CommandSyntaxException {
        int successCount = CommandMixin.enchantTargets(targets, enchantment, level);
        if (successCount == 0) {
            throw field_13630.create();
        }
        CommandMixin.sendFeedback(source, enchantment, level, targets, successCount);
        cir.setReturnValue((Object)successCount);
        cir.cancel();
    }

    @Unique
    private static int enchantTargets(Collection<? extends class_1297> targets, class_1887 enchantment, int level) throws CommandSyntaxException {
        int successCount = 0;
        for (class_1297 class_12972 : targets) {
            if (!(class_12972 instanceof class_1309)) {
                if (targets.size() != 1) continue;
                throw field_13629.create((Object)class_12972.method_5477());
            }
            class_1309 livingEntity = (class_1309)class_12972;
            class_1799 itemStack = livingEntity.method_6047();
            if (itemStack.method_7960()) {
                if (targets.size() != 1) continue;
                throw field_13631.create((Object)livingEntity.method_5477());
            }
            if (!enchantment.method_8192(itemStack)) {
                if (targets.size() != 1) continue;
                throw field_13633.create((Object)itemStack.method_7909().method_7848());
            }
            CommandMixin.applyEnchantment(itemStack, enchantment, level);
            ++successCount;
        }
        return successCount;
    }

    @Unique
    private static void applyEnchantment(class_1799 itemStack, class_1887 enchantment, int level) {
        class_2487 nbt = itemStack.method_7948();
        class_2499 enchantments = nbt.method_10554("Enchantments", 10);
        if (enchantments == null) {
            enchantments = new class_2499();
        }
        class_2487 enchantmentNbt = new class_2487();
        String enchantmentId = class_2378.field_11160.method_10221((Object)enchantment).toString();
        enchantmentNbt.method_10582("id", enchantmentId);
        enchantmentNbt.method_10569("lvl", level);
        enchantments.removeIf(element -> ((class_2487)element).method_10558("id").equals(enchantmentId));
        enchantments.add((Object)enchantmentNbt);
        nbt.method_10566("Enchantments", (class_2520)enchantments);
    }

    @Unique
    private static void sendFeedback(class_2168 source, class_1887 enchantment, int level, Collection<? extends class_1297> targets, int successCount) {
        if (targets.size() == 1) {
            source.method_9226((class_2561)class_2561.method_43469((String)"commands.enchant.success.single", (Object[])new Object[]{enchantment.method_8179(level), targets.iterator().next().method_5476()}), true);
        } else {
            source.method_9226((class_2561)class_2561.method_43469((String)"commands.enchant.success.multiple", (Object[])new Object[]{enchantment.method_8179(level), successCount}), true);
        }
    }
}

