/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.enchantmentlevelbreak.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class CEnchantCommand {
    private static final SuggestionProvider<class_2168> SUGGEST_ENCHANTMENTS = (context, builder) -> {
        class_5455 registryManager = ((class_2168)context.getSource()).method_9225().method_30349();
        class_2378 registry = registryManager.method_30530(class_7924.field_41265);
        return class_2172.method_9270((Iterable)registry.method_10235(), (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"cenchant").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"enchantment", (ArgumentType)StringArgumentType.greedyString()).suggests(SUGGEST_ENCHANTMENTS).executes(context -> CEnchantCommand.enchantItem((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"enchantment"), 1))).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> CEnchantCommand.enchantItem((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"enchantment"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level"))))));
    }

    private static int enchantItem(class_2168 source, String enchantmentInput, int level) {
        try {
            class_3222 player = source.method_44023();
            class_1799 itemStack = player.method_6047();
            if (itemStack.method_7960()) {
                source.method_9213((class_2561)class_2561.method_43471((String)"command.enchantmentlevelbreak.cenchant.no_item"));
                return 0;
            }
            String[] parts = enchantmentInput.split("\\s+", 2);
            String enchantmentName = parts[0];
            if (parts.length > 1) {
                try {
                    long longLevel = Long.parseLong(parts[1]);
                    if (longLevel > Integer.MAX_VALUE) {
                        source.method_9213((class_2561)class_2561.method_43469((String)"command.enchantmentlevelbreak.cenchant.level_too_high", (Object[])new Object[]{Integer.MAX_VALUE}));
                        return 0;
                    }
                    level = (int)longLevel;
                }
                catch (NumberFormatException longLevel) {
                    // empty catch block
                }
            }
            if (level > Integer.MAX_VALUE || level < 1) {
                source.method_9213((class_2561)class_2561.method_43469((String)"command.enchantmentlevelbreak.cenchant.level_too_high", (Object[])new Object[]{Integer.MAX_VALUE}));
                return 0;
            }
            Object fullName = enchantmentName.contains(":") ? enchantmentName : "minecraft:" + enchantmentName;
            class_2960 enchantmentId = class_2960.method_12829((String)fullName);
            if (enchantmentId == null) {
                source.method_9213((class_2561)class_2561.method_43469((String)"command.enchantmentlevelbreak.cenchant.invalid_enchantment", (Object[])new Object[]{fullName}));
                return 0;
            }
            class_5455 registryManager = source.method_9225().method_30349();
            class_2378 registry = registryManager.method_30530(class_7924.field_41265);
            class_6880 enchantmentEntry = registry.method_10223(enchantmentId).orElse(null);
            if (enchantmentEntry == null) {
                source.method_9213((class_2561)class_2561.method_43469((String)"command.enchantmentlevelbreak.cenchant.invalid_enchantment", (Object[])new Object[]{enchantmentName}));
                return 0;
            }
            itemStack.method_7978(enchantmentEntry, level);
            int finalLevel = level;
            source.method_9226(() -> class_2561.method_43469((String)"command.enchantmentlevelbreak.cenchant.success", (Object[])new Object[]{class_1887.method_8179((class_6880)enchantmentEntry, (int)finalLevel)}), true);
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("An error occurred while executing the command: " + e.getMessage())));
            return 0;
        }
    }
}

