/*
 * Decompiled with CFR 0.152.
 */
package com.lirxowo.enchantmentlevelbreak;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class CEnchantCommand {
    private static final SuggestionProvider<CommandSource> SUGGEST_ENCHANTMENTS = (context, builder) -> ISuggestionProvider.func_197014_a((Iterable)Registry.field_212628_q.func_148742_b(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"cenchant").requires(source -> source.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"enchantment", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SUGGEST_ENCHANTMENTS).executes(context -> CEnchantCommand.enchantItem((CommandSource)context.getSource(), (Enchantment)Registry.field_212628_q.func_82594_a(ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"enchantment")), 1))).then(Commands.func_197056_a((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> CEnchantCommand.enchantItem((CommandSource)context.getSource(), (Enchantment)Registry.field_212628_q.func_82594_a(ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"enchantment")), IntegerArgumentType.getInteger((CommandContext)context, (String)"level"))))));
    }

    private static int enchantItem(CommandSource source, Enchantment enchantment, int level) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        ItemStack itemStack = player.func_184614_ca();
        if (itemStack.func_190926_b()) {
            source.func_197021_a((ITextComponent)new StringTextComponent("You must be holding an item to enchant"));
            return 0;
        }
        if (enchantment == null) {
            source.func_197021_a((ITextComponent)new StringTextComponent("Invalid enchantment"));
            return 0;
        }
        Map currentEnchantments = EnchantmentHelper.func_82781_a((ItemStack)itemStack);
        currentEnchantments.remove(enchantment);
        currentEnchantments.put(enchantment, level);
        EnchantmentHelper.func_82782_a((Map)currentEnchantments, (ItemStack)itemStack);
        source.func_197030_a((ITextComponent)new StringTextComponent("Applied " + enchantment.func_200305_d(level).getString() + " to the item"), true);
        return 1;
    }
}

