/*
 * Decompiled with CFR 0.152.
 */
package com.lirxowo.enchantmentlevelbreak.mixin;

import com.lirxowo.enchantmentlevelbreak.config.Config;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IntReferenceHolder;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RepairContainer.class})
public abstract class AnvilMenuMixin {
    @Shadow
    @Final
    private IntReferenceHolder field_82854_e;
    @Shadow
    private int field_82856_l;

    @Inject(method={"createResult"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCreateResult(CallbackInfo ci) {
        RepairContainer container = (RepairContainer)this;
        Slot slot0 = (Slot)container.field_75151_b.get(0);
        Slot slot1 = (Slot)container.field_75151_b.get(1);
        Slot slot2 = (Slot)container.field_75151_b.get(2);
        ItemStack left = slot0.func_75211_c();
        ItemStack right = slot1.func_75211_c();
        if (!left.func_190926_b() && !right.func_190926_b()) {
            this.handleAnvilOperation(slot2, left, right, ci);
        }
    }

    @Unique
    private void handleAnvilOperation(Slot resultSlot, ItemStack left, ItemStack right, CallbackInfo ci) {
        Map leftEnchants = EnchantmentHelper.func_82781_a((ItemStack)left);
        Map rightEnchants = EnchantmentHelper.func_82781_a((ItemStack)right);
        if (left.func_77973_b() == right.func_77973_b()) {
            if (!leftEnchants.isEmpty() || !rightEnchants.isEmpty()) {
                this.handleEnchantmentMerge(resultSlot, left, leftEnchants, rightEnchants, true, ci);
            }
            return;
        }
        if (!rightEnchants.isEmpty() && right.func_77973_b() == Items.field_151134_bR) {
            this.handleEnchantmentMerge(resultSlot, left, leftEnchants, rightEnchants, false, ci);
        }
    }

    @Unique
    private void handleEnchantmentMerge(Slot resultSlot, ItemStack target, Map<Enchantment, Integer> leftEnchants, Map<Enchantment, Integer> rightEnchants, boolean isSameItemMerge, CallbackInfo ci) {
        if (!(Config.allowLevelStacking || Config.allowVanillaLevelStacking || Config.allowAnyEnchantment)) {
            return;
        }
        HashMap<Enchantment, Integer> resultEnchants = new HashMap<Enchantment, Integer>(leftEnchants);
        boolean anyEnchantmentApplied = false;
        int totalCost = 0;
        for (Map.Entry<Enchantment, Integer> entry : rightEnchants.entrySet()) {
            Enchantment enchantment = entry.getKey();
            int rightLevel = entry.getValue();
            boolean canApply = isSameItemMerge || Config.allowAnyEnchantment || enchantment.func_92089_a(target);
            if (!canApply) continue;
            int leftLevel = resultEnchants.getOrDefault(enchantment, 0);
            int newLevel = this.calculateNewLevel(leftLevel, rightLevel);
            newLevel = Math.min(newLevel, Config.maxEnchantmentLevel);
            resultEnchants.put(enchantment, newLevel);
            totalCost += newLevel;
            anyEnchantmentApplied = true;
        }
        if (anyEnchantmentApplied) {
            ItemStack result = target.func_77946_l();
            EnchantmentHelper.func_82782_a(resultEnchants, (ItemStack)result);
            resultSlot.func_75215_d(result);
            int finalCost = Math.max(1, Math.min(totalCost, 39));
            this.field_82854_e.func_221494_a(finalCost);
            this.field_82856_l = 1;
            ci.cancel();
        }
    }

    @Unique
    private int calculateNewLevel(int leftLevel, int rightLevel) {
        if (Config.allowLevelStacking) {
            return leftLevel + rightLevel;
        }
        if (Config.allowVanillaLevelStacking && leftLevel == rightLevel) {
            return leftLevel + 1;
        }
        return Math.max(leftLevel, rightLevel);
    }
}

