/*
 * Decompiled with CFR 0.152.
 */
package com.lirxowo.enchantmentlevelbreak.mixin;

import com.lirxowo.enchantmentlevelbreak.config.Config;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Enchantment.class})
public class EnchantmentMixin {
    @Inject(method={"getFullname"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyEnchantmentName(int level, CallbackInfoReturnable<ITextComponent> cir) {
        Enchantment enchantment = (Enchantment)this;
        TranslationTextComponent name = new TranslationTextComponent(enchantment.func_77320_a());
        if (level != 1) {
            String levelText = level > 10000 ? String.valueOf(level) : (Config.useRomanNumerals ? EnchantmentMixin.enchantmentLevelBreak$intToRoman(level) : String.valueOf(level));
            name.func_240702_b_(" ").func_230529_a_((ITextComponent)new StringTextComponent(levelText).func_240699_a_(TextFormatting.GRAY));
        }
        cir.setReturnValue((Object)name);
    }

    @Unique
    private static String enchantmentLevelBreak$intToRoman(int num) {
        if (num <= 0) {
            return "0";
        }
        int[] values = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] symbols = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        StringBuilder roman = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            while (num >= values[i]) {
                roman.append(symbols[i]);
                num -= values[i];
            }
        }
        return roman.toString();
    }
}

