/*
 * Decompiled with CFR 0.152.
 */
package com.lirxowo.enchantmentlevelbreak.mixin;

import com.lirxowo.enchantmentlevelbreak.config.Config;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EnchantmentHelper.class})
public class Helper {
    @Inject(method={"setEnchantments(Ljava/util/Map;Lnet/minecraft/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onSetEnchantments(Map<Enchantment, Integer> enchantments, ItemStack stack, CallbackInfo ci) {
        ListNBT listnbt = new ListNBT();
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == null) continue;
            int level = entry.getValue();
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74778_a("id", String.valueOf(Registry.field_212628_q.func_177774_c((Object)enchantment)));
            compoundnbt.func_74768_a("lvl", level);
            listnbt.add((Object)compoundnbt);
        }
        if (stack.func_77973_b() == Items.field_151134_bR) {
            if (listnbt.isEmpty()) {
                stack.func_196083_e("StoredEnchantments");
            } else {
                stack.func_77983_a("StoredEnchantments", (INBT)listnbt);
            }
        } else if (listnbt.isEmpty()) {
            stack.func_196083_e("Enchantments");
        } else {
            stack.func_77983_a("Enchantments", (INBT)listnbt);
        }
        ci.cancel();
    }

    @Redirect(method={"getItemEnchantmentLevel(Lnet/minecraft/enchantment/Enchantment;Lnet/minecraft/item/ItemStack;)I"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;clamp(III)I"))
    private static int redirectClamp(int value, int min, int max) {
        return MathHelper.func_76125_a((int)value, (int)min, (int)Config.maxEnchantmentLevel);
    }
}

