/*
 * Decompiled with CFR 0.152.
 */
package com.prizowo.enchantmentlevelbreak;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class CEnchantCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_ENCHANTMENTS = (context, builder) -> SharedSuggestionProvider.m_82926_((Iterable)Registry.f_122825_.m_6566_(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cenchant").requires(source -> source.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"enchantment", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_ENCHANTMENTS).executes(context -> CEnchantCommand.enchantItem((CommandSourceStack)context.getSource(), (Enchantment)Registry.f_122825_.m_7745_(ResourceLocationArgument.m_107011_((CommandContext)context, (String)"enchantment")), 1))).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> CEnchantCommand.enchantItem((CommandSourceStack)context.getSource(), (Enchantment)Registry.f_122825_.m_7745_(ResourceLocationArgument.m_107011_((CommandContext)context, (String)"enchantment")), IntegerArgumentType.getInteger((CommandContext)context, (String)"level"))))));
    }

    private static int enchantItem(CommandSourceStack source, Enchantment enchantment, int level) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        ItemStack itemStack = player.m_21205_();
        if (itemStack.m_41619_()) {
            source.m_81352_((Component)Component.m_237113_((String)"You must be holding an item to enchant"));
            return 0;
        }
        if (enchantment == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Invalid enchantment"));
            return 0;
        }
        Map currentEnchantments = EnchantmentHelper.m_44831_((ItemStack)itemStack);
        currentEnchantments.remove(enchantment);
        currentEnchantments.put(enchantment, level);
        EnchantmentHelper.m_44865_((Map)currentEnchantments, (ItemStack)itemStack);
        source.m_81354_((Component)Component.m_237113_((String)("Applied " + enchantment.m_44700_(level).getString() + " to the item")), true);
        return 1;
    }
}

