/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.enchantmentlevelbreak.config;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="enchantmentlevelbreak", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.BooleanValue USE_ROMAN_NUMERALS_VALUE = BUILDER.comment("Use roman numerals for enchantment levels instead of arabic numbers").define("useRomanNumerals", true);
    private static final ModConfigSpec.BooleanValue ALLOW_ANY_ENCHANTMENT_VALUE = BUILDER.comment("Allow applying any enchantment book to any item in anvil").define("allowAnyEnchantment", false);
    private static final ModConfigSpec.BooleanValue ALLOW_VANILLA_LEVEL_STACKING_VALUE = BUILDER.comment("Allow vanilla enchantment level stacking in anvil (e.g. 4+4=5, same level +1)").define("allowVanillaLevelStacking", true);
    private static final ModConfigSpec.BooleanValue ALLOW_LEVEL_STACKING_VALUE = BUILDER.comment("Allow unlimited enchantment level stacking in anvil (e.g. 4+4=8 instead of vanilla's 4+4=5)").define("allowLevelStacking", false);
    private static final ModConfigSpec.IntValue MAX_ENCHANTMENT_LEVEL_VALUE = BUILDER.comment("Maximum enchantment level allowed (range: 255 to 2147483647)").defineInRange("maxEnchantmentLevel", Integer.MAX_VALUE, 255, Integer.MAX_VALUE);
    public static final ModConfigSpec SPEC = BUILDER.build();
    public static boolean useRomanNumerals;
    public static boolean allowAnyEnchantment;
    public static boolean allowVanillaLevelStacking;
    public static boolean allowLevelStacking;
    public static int maxEnchantmentLevel;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        useRomanNumerals = (Boolean)USE_ROMAN_NUMERALS_VALUE.get();
        allowAnyEnchantment = (Boolean)ALLOW_ANY_ENCHANTMENT_VALUE.get();
        allowVanillaLevelStacking = (Boolean)ALLOW_VANILLA_LEVEL_STACKING_VALUE.get();
        allowLevelStacking = (Boolean)ALLOW_LEVEL_STACKING_VALUE.get();
        maxEnchantmentLevel = (Integer)MAX_ENCHANTMENT_LEVEL_VALUE.get();
    }
}

