/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.enchantmentlevelbreak.mixin;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import net.minecraft.class_6880;
import net.minecraft.class_8047;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.prizowo.enchantmentlevelbreak.config.ModConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1706.class})
public abstract class AnvilMenuMixin
extends class_4861 {
    @Shadow
    private int field_7776;
    @Shadow
    private final class_3915 field_7770 = class_3915.method_17403();

    protected AnvilMenuMixin(class_3917<?> type, int syncId, class_1661 playerInventory, class_3914 context) {
        super(type, syncId, playerInventory, context, AnvilMenuMixin.getForgingSlotsManager());
    }

    @Unique
    private static class_8047 getForgingSlotsManager() {
        return class_8047.method_48364().method_48374(0, 27, 47, stack -> true).method_48374(1, 76, 47, stack -> true).method_48373(2, 134, 47).method_48372();
    }

    @Inject(method={"updateResult"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUpdateResult(CallbackInfo ci) {
        class_1799 left = this.field_22480.method_5438(0);
        class_1799 right = this.field_22480.method_5438(1);
        if (!left.method_7960() && !right.method_7960()) {
            this.handleAnvilOperation(left, right, ci);
        }
    }

    @Unique
    private void handleAnvilOperation(class_1799 left, class_1799 right, CallbackInfo ci) {
        boolean sameItem = left.method_31574(right.method_7909());
        boolean rightIsBook = right.method_31574(class_1802.field_8598);
        class_9304 leftEnchants = this.getEnchantments(left);
        class_9304 rightEnchants = this.getEnchantments(right);
        if (sameItem) {
            if (!leftEnchants.method_57543() || !rightEnchants.method_57543()) {
                this.handleEnchantmentMerge(left, leftEnchants, rightEnchants, true, ci);
            }
            return;
        }
        if (!(rightEnchants.method_57543() || !rightIsBook && this.getEnchantments(right).method_57543())) {
            this.handleEnchantmentMerge(left, leftEnchants, rightEnchants, false, ci);
        }
    }

    @Unique
    private void handleEnchantmentMerge(class_1799 target, class_9304 leftEnchants, class_9304 rightEnchants, boolean isSameItemMerge, CallbackInfo ci) {
        class_1799 result = target.method_7972();
        class_9304.class_9305 builder = new class_9304.class_9305(leftEnchants);
        boolean anyApplied = false;
        int totalCost = 0;
        for (Object2IntMap.Entry entry : rightEnchants.method_57539()) {
            class_6880 enchantment = (class_6880)entry.getKey();
            int rightLevel = entry.getIntValue();
            boolean canApply = isSameItemMerge || ModConfig.getInstance().isAllowAnyEnchantment() || ((class_1887)enchantment.comp_349()).method_8192(target);
            if (!canApply) continue;
            int leftLevel = leftEnchants.method_57536(enchantment);
            int newLevel = this.calculateNewLevel(leftLevel, rightLevel);
            newLevel = Math.min(newLevel, ModConfig.getInstance().getMaxEnchantmentLevel());
            builder.method_57547(enchantment, newLevel);
            totalCost += newLevel;
            anyApplied = true;
        }
        if (anyApplied) {
            class_9304 newEnchants = builder.method_57549();
            this.setEnchantments(result, newEnchants);
            this.field_22479.method_5447(0, result);
            this.field_7776 = Math.min(totalCost, 50);
            this.field_7770.method_17404(this.field_7776);
            ci.cancel();
        }
    }

    @Unique
    private class_9304 getEnchantments(class_1799 stack) {
        if (stack.method_31574(class_1802.field_8598)) {
            return (class_9304)stack.method_57825(class_9334.field_49643, (Object)class_9304.field_49385);
        }
        return (class_9304)stack.method_57825(class_9334.field_49633, (Object)class_9304.field_49385);
    }

    @Unique
    private void setEnchantments(class_1799 stack, class_9304 enchantments) {
        if (stack.method_31574(class_1802.field_8598)) {
            stack.method_57379(class_9334.field_49643, (Object)enchantments);
            if (stack.method_57826(class_9334.field_49633)) {
                stack.method_57381(class_9334.field_49633);
            }
        } else {
            stack.method_57379(class_9334.field_49633, (Object)enchantments);
        }
    }

    @Unique
    private int calculateNewLevel(int leftLevel, int rightLevel) {
        if (ModConfig.getInstance().isAllowLevelStacking()) {
            return leftLevel + rightLevel;
        }
        if (ModConfig.getInstance().isAllowVanillaLevelStacking() && leftLevel == rightLevel) {
            return leftLevel + 1;
        }
        return Math.max(leftLevel, rightLevel);
    }
}

