/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.enchantmentlevelbreak.mixin;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.prizowo.enchantmentlevelbreak.config.Config;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilMenuMixin
extends ItemCombinerMenu {
    @Shadow
    public int repairItemCountCost;
    @Shadow
    private final DataSlot cost = DataSlot.standalone();

    protected AnvilMenuMixin(int containerId, ContainerLevelAccess access) {
        super(null, containerId, null, access, null);
    }

    @Inject(method={"createResult"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCreateResult(CallbackInfo ci) {
        ItemStack left = this.inputSlots.getItem(0);
        ItemStack right = this.inputSlots.getItem(1);
        if (!left.isEmpty() && !right.isEmpty()) {
            this.handleAnvilOperation(left, right, ci);
        }
    }

    @Unique
    private void handleAnvilOperation(ItemStack left, ItemStack right, CallbackInfo ci) {
        ItemEnchantments effectiveRight;
        boolean sameItem = left.is(right.getItem());
        boolean rightIsBook = right.is(Items.ENCHANTED_BOOK);
        ItemEnchantments leftEnchants = (ItemEnchantments)left.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments rightEnchants = (ItemEnchantments)right.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments leftStoredEnchants = (ItemEnchantments)left.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments rightStoredEnchants = (ItemEnchantments)right.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments effectiveLeft = !leftStoredEnchants.isEmpty() ? leftStoredEnchants : leftEnchants;
        ItemEnchantments itemEnchantments = effectiveRight = !rightStoredEnchants.isEmpty() ? rightStoredEnchants : rightEnchants;
        if (sameItem) {
            if (!effectiveLeft.isEmpty() || !effectiveRight.isEmpty()) {
                this.handleEnchantmentMerge(left, effectiveLeft, effectiveRight, true, ci);
            }
            return;
        }
        if (!(effectiveRight.isEmpty() || !rightIsBook && rightEnchants.isEmpty())) {
            this.handleEnchantmentMerge(left, effectiveLeft, effectiveRight, false, ci);
        }
    }

    @Unique
    private void handleEnchantmentMerge(ItemStack target, ItemEnchantments leftEnchants, ItemEnchantments rightEnchants, boolean isSameItemMerge, CallbackInfo ci) {
        ItemStack result = target.copy();
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(leftEnchants);
        boolean anyApplied = false;
        int totalCost = 0;
        for (Object2IntMap.Entry entry : rightEnchants.entrySet()) {
            Holder enchantment = (Holder)entry.getKey();
            int rightLevel = entry.getIntValue();
            boolean canApply = isSameItemMerge || Config.allowAnyEnchantment || ((Enchantment)enchantment.value()).canEnchant(target);
            if (!canApply) continue;
            int leftLevel = mutable.getLevel(enchantment);
            int newLevel = this.calculateNewLevel(leftLevel, rightLevel);
            newLevel = Math.min(newLevel, Config.maxEnchantmentLevel);
            mutable.set(enchantment, newLevel);
            totalCost += newLevel;
            anyApplied = true;
        }
        if (anyApplied) {
            if (result.is(Items.ENCHANTED_BOOK)) {
                result.set(DataComponents.STORED_ENCHANTMENTS, (Object)mutable.toImmutable());
                if (result.has(DataComponents.ENCHANTMENTS)) {
                    result.remove(DataComponents.ENCHANTMENTS);
                }
            } else {
                result.set(DataComponents.ENCHANTMENTS, (Object)mutable.toImmutable());
            }
            this.resultSlots.setItem(0, result);
            this.repairItemCountCost = Math.min(totalCost, 50);
            this.cost.set(this.repairItemCountCost);
            ci.cancel();
        }
    }

    @Unique
    private int calculateNewLevel(int leftLevel, int rightLevel) {
        if (Config.allowLevelStacking) {
            return leftLevel + rightLevel;
        }
        if (Config.allowVanillaLevelStacking && leftLevel == rightLevel) {
            return leftLevel + 1;
        }
        return Math.max(leftLevel, rightLevel);
    }
}

