/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.zombifiedplayer.client.render;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.PlayerSkinRenderCache;
import net.minecraft.client.renderer.entity.AbstractZombieRenderer;
import net.minecraft.client.renderer.entity.ArmorModelSet;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.ZombieRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.component.ResolvableProfile;
import net.petemc.zombifiedplayer.ZombifiedPlayer;
import net.petemc.zombifiedplayer.client.render.entity.feature.ZombificationFeatureRenderer;
import net.petemc.zombifiedplayer.client.render.entity.state.ZombifiedPlayerEntityRenderState;
import net.petemc.zombifiedplayer.config.MainConfig;
import net.petemc.zombifiedplayer.entity.ZombifiedPlayerEntity;
import org.jetbrains.annotations.NotNull;

public class ZombifiedPlayerRenderer
extends AbstractZombieRenderer<ZombifiedPlayerEntity, ZombifiedPlayerEntityRenderState, ZombieModel<ZombifiedPlayerEntityRenderState>> {
    private static ResourceLocation TEXTURE_FALLBACK = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/player/wide/steve.png");
    private static GameProfile receivedGameProfile = null;
    private static GameProfile inProgress = null;
    private boolean gameProfileReceived = false;
    private final int counterSteps = 40;
    private final int maxSubTries = 5;
    private final int maxTotalTries = 5;
    private final int counterMax = 2200;
    private int counter = 2200;
    private int totalTries = 0;

    public ZombifiedPlayerRenderer(EntityRendererProvider.Context ctx) {
        this(ctx, ModelLayers.ZOMBIE, ModelLayers.ZOMBIE_BABY, (ArmorModelSet<ModelLayerLocation>)ModelLayers.ZOMBIE_ARMOR, (ArmorModelSet<ModelLayerLocation>)ModelLayers.ZOMBIE_BABY_ARMOR);
        this.addLayer(new ZombificationFeatureRenderer((RenderLayerParent<ZombifiedPlayerEntityRenderState, ZombieModel<ZombifiedPlayerEntityRenderState>>)this));
    }

    public ZombifiedPlayerRenderer(EntityRendererProvider.Context ctx, ModelLayerLocation layer, ModelLayerLocation legsArmorLayer, ArmorModelSet<ModelLayerLocation> equipmentModelData, ArmorModelSet<ModelLayerLocation> equipmentModelData2) {
        super(ctx, new ZombieModel(ctx.bakeLayer(layer)), new ZombieModel(ctx.bakeLayer(legsArmorLayer)), ArmorModelSet.bake(equipmentModelData, (EntityModelSet)ctx.getModelSet(), ZombieModel::new), ArmorModelSet.bake(equipmentModelData2, (EntityModelSet)ctx.getModelSet(), ZombieModel::new));
    }

    @NotNull
    public ZombifiedPlayerEntityRenderState createRenderState() {
        return new ZombifiedPlayerEntityRenderState();
    }

    public void extractRenderState(@NotNull ZombifiedPlayerEntity entity, @NotNull ZombifiedPlayerEntityRenderState reusedState, float partialTick) {
        super.extractRenderState((Zombie)entity, (ZombieRenderState)reusedState, partialTick);
        reusedState.gameProfile = entity.getGameProfile();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ZombifiedPlayerEntityRenderState zombifiedPlayerEntityRenderState) {
        if (zombifiedPlayerEntityRenderState.gameProfile != null) {
            if (ZombifiedPlayer.cachedPlayerSkinsByUUID.containsKey(zombifiedPlayerEntityRenderState.gameProfile.id())) {
                zombifiedPlayerEntityRenderState.skinTexture = ZombifiedPlayer.cachedPlayerSkinsByUUID.get(zombifiedPlayerEntityRenderState.gameProfile.id());
                return ZombifiedPlayer.cachedPlayerSkinsByUUID.get(zombifiedPlayerEntityRenderState.gameProfile.id());
            }
            if (ZombifiedPlayer.uuidMissmatches.containsKey(zombifiedPlayerEntityRenderState.gameProfile.id()) && (ZombifiedPlayer.cachedPlayerSkinsByName.containsKey(zombifiedPlayerEntityRenderState.gameProfile.name()) || ZombifiedPlayer.cachedPlayerSkinsByName.containsKey(zombifiedPlayerEntityRenderState.gameProfile.name().toLowerCase()))) {
                zombifiedPlayerEntityRenderState.skinTexture = ZombifiedPlayer.cachedPlayerSkinsByUUID.get(ZombifiedPlayer.uuidMissmatches.get(zombifiedPlayerEntityRenderState.gameProfile.id()));
                return ZombifiedPlayer.cachedPlayerSkinsByUUID.get(ZombifiedPlayer.uuidMissmatches.get(zombifiedPlayerEntityRenderState.gameProfile.id()));
            }
            if (zombifiedPlayerEntityRenderState.gameProfile != null) {
                this.getPlayerSkinFromGameProfile(zombifiedPlayerEntityRenderState.gameProfile);
            }
        }
        return TEXTURE_FALLBACK;
    }

    public void setTexture(ResourceLocation id) {
        TEXTURE_FALLBACK = id;
    }

    public void getPlayerSkinFromGameProfile(GameProfile profile) {
        try {
            if (inProgress == null) {
                inProgress = profile;
            }
            if (!inProgress.id().equals(profile.id())) {
                return;
            }
            if (this.counter > 2195 && this.totalTries < 5) {
                if (receivedGameProfile == null) {
                    if (this.counter == 2200) {
                        ZombifiedPlayer.LOGGER.info("Trying to get GameProfile for {} UUID: {}", (Object)profile.name(), (Object)profile.id());
                    }
                    receivedGameProfile = this.getGameProfile(profile);
                }
                if (!this.gameProfileReceived && receivedGameProfile != null) {
                    ZombifiedPlayer.LOGGER.info("Successfully received GameProfile for {}, UUID: {}", (Object)receivedGameProfile.name(), (Object)receivedGameProfile.id());
                    this.counter = 2200;
                    this.totalTries = 0;
                    this.gameProfileReceived = true;
                }
                if (receivedGameProfile != null) {
                    Minecraft minecraft = Minecraft.getInstance();
                    PlayerSkin skinTexture = null;
                    Optional optionalSkinTextures = (Optional)minecraft.getSkinManager().get(receivedGameProfile).get(100L, TimeUnit.MILLISECONDS);
                    int tries = 5;
                    while (!minecraft.getSkinManager().get(receivedGameProfile).isDone() && tries > 0) {
                        try {
                            optionalSkinTextures = (Optional)minecraft.getSkinManager().get(receivedGameProfile).get(50L, TimeUnit.MILLISECONDS);
                        }
                        catch (TimeoutException timeoutException) {
                            --tries;
                        }
                    }
                    if (optionalSkinTextures.isPresent()) {
                        skinTexture = (PlayerSkin)optionalSkinTextures.get();
                    }
                    if (skinTexture != null) {
                        if (!receivedGameProfile.id().equals(profile.id())) {
                            ZombifiedPlayer.LOGGER.info("The zombified player for {} has a different UUID, using random default skin!", (Object)receivedGameProfile.name());
                            ZombifiedPlayer.uuidMissmatches.put(profile.id(), receivedGameProfile.id());
                            ZombifiedPlayer.cachedPlayerSkinsByName.put(receivedGameProfile.name(), skinTexture.body().texturePath());
                        }
                        ZombifiedPlayer.cachedPlayerSkinsByUUID.put(receivedGameProfile.id(), skinTexture.body().texturePath());
                        ZombifiedPlayer.LOGGER.info("Successfully received Skin for {}, UUID: {}", (Object)receivedGameProfile.name(), (Object)receivedGameProfile.id());
                        ZombifiedPlayer.LOGGER.info("Skin Texture: {}", (Object)skinTexture.body().id());
                        ZombifiedPlayer.LOGGER.info("Skin Texture URL: {}", (Object)skinTexture.body().texturePath());
                        this.counter = 2200;
                        this.totalTries = 0;
                        receivedGameProfile = null;
                        inProgress = null;
                        this.gameProfileReceived = false;
                        return;
                    }
                    ZombifiedPlayer.LOGGER.warn("No valid Skin was received for {}", (Object)receivedGameProfile.name());
                }
            }
            if (this.counter > 0) {
                --this.counter;
            } else {
                this.counter = 2200;
                ++this.totalTries;
                if (this.totalTries == 4) {
                    if (MainConfig.getLimitSkinFetchTries()) {
                        ZombifiedPlayer.LOGGER.warn("Could not fetch a valid Skin for {}, will stop trying.", (Object)profile.name());
                    } else {
                        this.totalTries = 0;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private GameProfile getGameProfile(GameProfile profile) {
        try {
            ResolvableProfile profileComponent = ResolvableProfile.createUnresolved((String)profile.name());
            CompletableFuture futureOptionalEntry = Minecraft.getInstance().playerSkinRenderCache().lookup(profileComponent);
            Optional optionalEntry = (Optional)futureOptionalEntry.get(100L, TimeUnit.MILLISECONDS);
            int tries = 5;
            while (!futureOptionalEntry.isDone() && tries > 0) {
                try {
                    futureOptionalEntry.get(50L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    --tries;
                }
            }
            return optionalEntry.map(PlayerSkinRenderCache.RenderInfo::gameProfile).orElse(null);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

