/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.zombifiedplayer.entity;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.extensions.IEntityExtension;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.petemc.zombifiedplayer.config.MainConfig;
import net.petemc.zombifiedplayer.entity.ModEntities;
import net.petemc.zombifiedplayer.util.CuriosUtil;
import org.jetbrains.annotations.NotNull;

public class ZombifiedPlayerEntity
extends Zombie
implements IEntityExtension,
IEntityWithComplexSpawn {
    public GameProfile gameProfile;
    public final NonNullList<ItemStack> main = NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
    public static final Int2ObjectMap<EquipmentSlot> EQUIPMENT_SLOT_MAPPING = new Int2ObjectArrayMap(Map.of(EquipmentSlot.FEET.getIndex(36), EquipmentSlot.FEET, EquipmentSlot.LEGS.getIndex(36), EquipmentSlot.LEGS, EquipmentSlot.CHEST.getIndex(36), EquipmentSlot.CHEST, EquipmentSlot.HEAD.getIndex(36), EquipmentSlot.HEAD, 40, EquipmentSlot.OFFHAND, 41, EquipmentSlot.BODY, 42, EquipmentSlot.SADDLE));
    public final List<ItemStack> curiosItems = new ArrayList<ItemStack>();

    public ZombifiedPlayerEntity(EntityType<? extends Zombie> entityType, Level level) {
        super(entityType, level);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, MainConfig.getMakeTheZombifiedPlayersStronger() ? 40.0 : 20.0).add(Attributes.FOLLOW_RANGE, MainConfig.getMakeTheZombifiedPlayersStronger() ? 50.0 : 40.0).add(Attributes.MOVEMENT_SPEED, MainConfig.getMakeTheZombifiedPlayersStronger() ? (double)0.29f : (double)0.23f).add(Attributes.ATTACK_DAMAGE, MainConfig.getMakeTheZombifiedPlayersStronger() ? 4.0 : 2.0).add(Attributes.ARMOR, MainConfig.getMakeTheZombifiedPlayersStronger() ? 4.0 : 2.0).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE);
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new ZombieAttackGoal((Zombie)this, 1.0, false));
        this.goalSelector.addGoal(6, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, true, 4, this::canBreakDoors));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public boolean fireImmune() {
        return MainConfig.getMakeTheZombifiedPlayersImmuneToFire();
    }

    protected boolean isSunSensitive() {
        return false;
    }

    public boolean canBreakDoors() {
        return MainConfig.getZombifiedPlayersCanBreakDoors();
    }

    protected boolean convertsInWater() {
        return false;
    }

    public void randomizeReinforcementsChance() {
        Objects.requireNonNull(this.getAttribute(Attributes.SPAWN_REINFORCEMENTS_CHANCE)).setBaseValue(0.0);
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    public void setGameProfile(GameProfile gameProfile) {
        this.gameProfile = gameProfile;
    }

    protected void dropCustomDeathLoot(@NotNull ServerLevel serverLevel, @NotNull DamageSource pDamageSource, boolean recentlyHit) {
        super.dropCustomDeathLoot(serverLevel, pDamageSource, recentlyHit);
        RandomSource random = this.getRandom();
        ItemStack rottenFleshStack = new ItemStack((ItemLike)Items.ROTTEN_FLESH, random.nextIntBetweenInclusive(1, 3));
        this.spawnAtLocation(serverLevel, rottenFleshStack);
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            ItemStack itemStack = this.getItemBySlot(equipmentSlot);
            this.spawnAtLocation(serverLevel, itemStack);
            this.setItemSlot(equipmentSlot, ItemStack.EMPTY);
        }
        this.dropInventory(serverLevel);
    }

    public void dropInventory(ServerLevel serverLevel) {
        for (int i = 0; i < this.main.size(); ++i) {
            if (((ItemStack)this.main.get(i)).isEmpty()) continue;
            this.spawnAtLocation(serverLevel, (ItemStack)this.main.get(i));
            this.main.set(i, (Object)ItemStack.EMPTY);
        }
        for (ItemStack curiosItem : this.curiosItems) {
            if (curiosItem.isEmpty()) continue;
            this.spawnAtLocation(serverLevel, curiosItem);
        }
        this.curiosItems.clear();
    }

    public static ZombifiedPlayerEntity spawnZombifiedPlayer(Player player) {
        ZombifiedPlayerEntity zombifiedPlayer = null;
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            zombifiedPlayer = new ZombifiedPlayerEntity(ModEntities.ZOMBIFIED_PLAYER.get(), (Level)serverLevel);
            zombifiedPlayer.setGameProfile(player.getGameProfile());
            MutableComponent name = Component.literal((String)("Zombified " + player.getName().getString()));
            zombifiedPlayer.setCustomName((Component)name);
            zombifiedPlayer.setPos(player.getX(), player.getY(), player.getZ());
            zombifiedPlayer.setPersistenceRequired();
            zombifiedPlayer.transferInventory(serverLevel, player);
            serverLevel.addFreshEntity((Entity)zombifiedPlayer);
        }
        return zombifiedPlayer;
    }

    public void transferInventory(ServerLevel serverLevel, Player playerEntity) {
        int i;
        if (EnchantmentHelper.has((ItemStack)playerEntity.getMainHandItem(), (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) {
            playerEntity.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        } else if (MainConfig.getTransferMainAndOffHandToZombifiedPlayer()) {
            this.setItemInHand(InteractionHand.MAIN_HAND, playerEntity.getMainHandItem().copyAndClear());
        }
        if (EnchantmentHelper.has((ItemStack)playerEntity.getMainHandItem(), (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) {
            playerEntity.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
        } else if (MainConfig.getTransferMainAndOffHandToZombifiedPlayer()) {
            this.setItemInHand(InteractionHand.OFF_HAND, playerEntity.getOffhandItem().copyAndClear());
        }
        for (i = 0; i < 4; ++i) {
            if (EnchantmentHelper.has((ItemStack)playerEntity.getMainHandItem(), (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) {
                playerEntity.setItemSlot((EquipmentSlot)EquipmentSlot.BY_ID.apply(i + 1), ItemStack.EMPTY);
                continue;
            }
            if (!MainConfig.getTransferArmorToZombifiedPlayer()) continue;
            this.equipItemIfPossible(serverLevel, playerEntity.getItemBySlot((EquipmentSlot)EquipmentSlot.BY_ID.apply(i + 1)).copyAndClear());
        }
        for (i = 0; i < playerEntity.getInventory().getNonEquipmentItems().size(); ++i) {
            if (((ItemStack)playerEntity.getInventory().getNonEquipmentItems().get(i)).isEmpty()) continue;
            if (EnchantmentHelper.has((ItemStack)playerEntity.getMainHandItem(), (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) {
                playerEntity.getInventory().getNonEquipmentItems().set(i, (Object)ItemStack.EMPTY);
                this.main.set(i, (Object)ItemStack.EMPTY);
            }
            if (!MainConfig.getTransferInventoryToZombifiedPlayer()) continue;
            this.main.set(i, (Object)((ItemStack)playerEntity.getInventory().getNonEquipmentItems().get(i)).copyAndClear());
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket(@NotNull ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity);
    }

    public void writeSpawnData(@NotNull RegistryFriendlyByteBuf buffer) {
        if (this.gameProfile != null) {
            buffer.writeUUID(this.gameProfile.id());
            buffer.writeUtf(this.gameProfile.name());
        }
    }

    public void readSpawnData(@NotNull RegistryFriendlyByteBuf additionalData) {
        try {
            UUID playerUUID = additionalData.readUUID();
            String playerName = additionalData.readUtf();
            this.gameProfile = new GameProfile(playerUUID, playerName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addAdditionalSaveData(@NotNull ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putString("gameProfileUUID", this.gameProfile.id().toString());
        valueOutput.putString("gameProfileName", this.gameProfile.name());
        this.saveInventory((ValueOutput.TypedOutputList<ItemStackWithSlot>)valueOutput.list("Inventory", ItemStackWithSlot.CODEC));
        CuriosUtil.saveCuriosItems((ValueOutput.TypedOutputList<ItemStackWithSlot>)valueOutput.list("CuriosItems", ItemStackWithSlot.CODEC), this.curiosItems);
    }

    public void readAdditionalSaveData(@NotNull ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        UUID gpUUID = UUID.fromString(valueInput.getString("gameProfileUUID").orElse(""));
        String gpName = valueInput.getString("gameProfileName").orElse("");
        this.gameProfile = new GameProfile(gpUUID, gpName);
        this.loadInventory((ValueInput.TypedInputList<ItemStackWithSlot>)valueInput.listOrEmpty("Inventory", ItemStackWithSlot.CODEC));
        CuriosUtil.loadCuriosItems((ValueInput.TypedInputList<ItemStackWithSlot>)valueInput.listOrEmpty("CuriosItems", ItemStackWithSlot.CODEC), this.curiosItems);
    }

    public void saveInventory(ValueOutput.TypedOutputList<ItemStackWithSlot> list) {
        for (int i = 0; i < this.main.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.main.get(i);
            if (itemstack.isEmpty()) continue;
            list.add((Object)new ItemStackWithSlot(i, itemstack));
        }
    }

    public void loadInventory(ValueInput.TypedInputList<ItemStackWithSlot> list) {
        this.main.clear();
        for (ItemStackWithSlot itemstackwithslot : list) {
            if (!itemstackwithslot.isValidInContainer(this.main.size())) continue;
            this.setItem(itemstackwithslot.slot(), itemstackwithslot.stack());
        }
    }

    public void setItem(int index, ItemStack stack) {
        EquipmentSlot equipmentslot;
        if (index < this.main.size()) {
            this.main.set(index, (Object)stack);
        }
        if ((equipmentslot = (EquipmentSlot)EQUIPMENT_SLOT_MAPPING.get(index)) != null) {
            this.equipment.set(equipmentslot, stack);
        }
    }
}

