/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.zombifiedplayer.event;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.petemc.zombifiedplayer.config.MainConfig;
import net.petemc.zombifiedplayer.entity.ModEntities;
import net.petemc.zombifiedplayer.entity.ZombifiedPlayerEntity;
import net.petemc.zombifiedplayer.util.ModCompatibility;

public class PlayerDeathEvents {
    public static boolean attackerIsUndead(Entity pAttacker) {
        boolean attackerIsUndead = false;
        if (pAttacker != null) {
            attackerIsUndead = pAttacker.getType() == EntityType.ZOMBIE || pAttacker.getType() == EntityType.HUSK || pAttacker.getType() == EntityType.ZOMBIFIED_PIGLIN || pAttacker.getType() == EntityType.DROWNED || pAttacker.getType() == EntityType.ZOMBIE_VILLAGER || pAttacker.getType() == EntityType.ZOGLIN || pAttacker.getType() == ModEntities.ZOMBIFIED_PLAYER.get();
        }
        attackerIsUndead = attackerIsUndead || ModCompatibility.wasKilledByHordeZombie(pAttacker);
        return attackerIsUndead;
    }

    public static void registerEvent() {
        new PlayerDeathEvents();
    }

    @EventBusSubscriber(modid="zombifiedplayer")
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onPlayerDeath(LivingDeathEvent event) {
            ServerPlayer serverPlayer;
            LivingEntity livingEntity;
            if (!event.getEntity().level().isClientSide() && (livingEntity = event.getEntity()) instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)livingEntity).getMainHandItem().is(Items.TOTEM_OF_UNDYING) && !serverPlayer.getOffhandItem().is(Items.TOTEM_OF_UNDYING) && (MainConfig.getSpawnOnAnyDeath() || ModCompatibility.diedFromInfection(serverPlayer) && MainConfig.getSpawnWhenKilledByInfection() || PlayerDeathEvents.attackerIsUndead(event.getSource().getEntity()) && MainConfig.getSpawnZombifiedPlayerAfterDeath())) {
                ZombifiedPlayerEntity.spawnZombifiedPlayer((Player)serverPlayer);
            }
        }
    }
}

