/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.zombifiedplayer.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.fml.ModList;

public class CuriosUtil {
    public static boolean isCuriosLoaded() {
        return ModList.get().isLoaded("curios");
    }

    public static List<ItemStack> getCuriosItemsAndClear(Player player) {
        ArrayList<ItemStack> curiosItems = new ArrayList<ItemStack>();
        if (!CuriosUtil.isCuriosLoaded()) {
            return curiosItems;
        }
        return curiosItems;
    }

    public static void saveCuriosItems(ValueOutput.TypedOutputList<ItemStackWithSlot> list, List<ItemStack> curiosItems) {
        for (int i = 0; i < curiosItems.size(); ++i) {
            ItemStack itemstack = curiosItems.get(i);
            if (itemstack.isEmpty()) continue;
            list.add((Object)new ItemStackWithSlot(i, itemstack));
        }
    }

    public static void loadCuriosItems(ValueInput.TypedInputList<ItemStackWithSlot> list, List<ItemStack> curiosItems) {
        curiosItems.clear();
        for (ItemStackWithSlot itemStackWithSlot : list) {
            if (!itemStackWithSlot.isValidInContainer(curiosItems.size())) continue;
            CuriosUtil.setItem(itemStackWithSlot.slot(), itemStackWithSlot.stack(), curiosItems);
            if (itemStackWithSlot.slot() >= curiosItems.size()) continue;
            curiosItems.set(itemStackWithSlot.slot(), itemStackWithSlot.stack());
        }
    }

    public static void setItem(int index, ItemStack itemStack, List<ItemStack> curiosItems) {
        if (index < curiosItems.size()) {
            curiosItems.set(index, itemStack);
        }
    }
}

