/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.zombifiedplayer.client.render;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10086;
import net.minecraft.class_11677;
import net.minecraft.class_11786;
import net.minecraft.class_1642;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_623;
import net.minecraft.class_8685;
import net.minecraft.class_9296;
import net.minecraft.class_968;
import net.petemc.zombifiedplayer.ZombifiedPlayer;
import net.petemc.zombifiedplayer.ZombifiedPlayerClient;
import net.petemc.zombifiedplayer.client.render.entity.feature.ZombificationFeatureRenderer;
import net.petemc.zombifiedplayer.client.render.entity.state.ZombifiedPlayerEntityRenderState;
import net.petemc.zombifiedplayer.config.MainConfig;
import net.petemc.zombifiedplayer.entity.ZombifiedPlayerEntity;

@Environment(value=EnvType.CLIENT)
public class ZombifiedPlayerRenderer
extends class_968<ZombifiedPlayerEntity, ZombifiedPlayerEntityRenderState, class_623<ZombifiedPlayerEntityRenderState>> {
    private static class_2960 TEXTURE_FALLBACK = class_2960.method_60655((String)"minecraft", (String)"textures/entity/player/wide/steve.png");
    private static GameProfile receivedGameProfile;
    private static GameProfile inProgress;
    private boolean gameProfileReceived = false;
    private final int maxTotalTries = 5;
    private final int maxSubTries = 10;
    private final int counterMax = 2010;
    private int counter = 2010;
    private int totalTries = 0;

    public ZombifiedPlayerRenderer(class_5617.class_5618 ctx) {
        this(ctx, class_5602.field_27638, class_5602.field_53008, (class_11677<class_5601>)class_5602.field_61714, (class_11677<class_5601>)class_5602.field_61713);
        this.method_4046(new ZombificationFeatureRenderer((class_3883<ZombifiedPlayerEntityRenderState, class_623<ZombifiedPlayerEntityRenderState>>)this));
    }

    public ZombifiedPlayerRenderer(class_5617.class_5618 ctx, class_5601 layer, class_5601 legsArmorLayer, class_11677<class_5601> equipmentModelData, class_11677<class_5601> equipmentModelData2) {
        super(ctx, new class_623(ctx.method_32167(layer)), new class_623(ctx.method_32167(legsArmorLayer)), class_11677.method_72961(equipmentModelData, (class_5599)ctx.method_32170(), class_623::new), class_11677.method_72961(equipmentModelData2, (class_5599)ctx.method_32170(), class_623::new));
    }

    public ZombifiedPlayerEntityRenderState createRenderState() {
        return new ZombifiedPlayerEntityRenderState();
    }

    public void updateRenderState(ZombifiedPlayerEntity zombifiedPlayerEntity, ZombifiedPlayerEntityRenderState zombifiedPlayerEntityRenderState, float f) {
        super.method_62369((class_1642)zombifiedPlayerEntity, (class_10086)zombifiedPlayerEntityRenderState, f);
        zombifiedPlayerEntityRenderState.gameProfile = zombifiedPlayerEntity.getGameProfile();
    }

    public void setTexture(class_2960 id) {
        TEXTURE_FALLBACK = id;
    }

    public class_2960 getTexture(ZombifiedPlayerEntityRenderState zombifiedPlayerEntityRenderState) {
        if (zombifiedPlayerEntityRenderState.gameProfile != null) {
            if (ZombifiedPlayerClient.cachedPlayerSkinsByUUID.containsKey(zombifiedPlayerEntityRenderState.gameProfile.id())) {
                zombifiedPlayerEntityRenderState.skinTexture = ZombifiedPlayerClient.cachedPlayerSkinsByUUID.get(zombifiedPlayerEntityRenderState.gameProfile.id());
                return ZombifiedPlayerClient.cachedPlayerSkinsByUUID.get(zombifiedPlayerEntityRenderState.gameProfile.id());
            }
            if (ZombifiedPlayerClient.uuidMissmatches.containsKey(zombifiedPlayerEntityRenderState.gameProfile.id()) && (ZombifiedPlayerClient.cachedPlayerSkinsByName.containsKey(zombifiedPlayerEntityRenderState.gameProfile.name()) || ZombifiedPlayerClient.cachedPlayerSkinsByName.containsKey(zombifiedPlayerEntityRenderState.gameProfile.name().toLowerCase()))) {
                zombifiedPlayerEntityRenderState.skinTexture = ZombifiedPlayerClient.cachedPlayerSkinsByUUID.get(ZombifiedPlayerClient.uuidMissmatches.get(zombifiedPlayerEntityRenderState.gameProfile.id()));
                return ZombifiedPlayerClient.cachedPlayerSkinsByUUID.get(ZombifiedPlayerClient.uuidMissmatches.get(zombifiedPlayerEntityRenderState.gameProfile.id()));
            }
            if (zombifiedPlayerEntityRenderState.gameProfile != null) {
                this.getPlayerSkinFromGameProfile(zombifiedPlayerEntityRenderState.gameProfile);
            }
        }
        return TEXTURE_FALLBACK;
    }

    public void getPlayerSkinFromGameProfile(GameProfile profile) {
        try {
            if (inProgress == null) {
                inProgress = profile;
            }
            if (!inProgress.id().equals(profile.id())) {
                return;
            }
            if (this.counter > 2000 && this.totalTries < 5) {
                if (receivedGameProfile == null) {
                    if (this.counter == 2010) {
                        ZombifiedPlayer.LOGGER.info("Trying to get GameProfile for {} UUID: {}", (Object)profile.name(), (Object)profile.id());
                    }
                    receivedGameProfile = this.getGameProfile(profile);
                }
                if (!this.gameProfileReceived && receivedGameProfile != null) {
                    ZombifiedPlayer.LOGGER.info("Successfully received GameProfile for {}, UUID: {}", (Object)receivedGameProfile.name(), (Object)receivedGameProfile.id());
                    this.counter = 2010;
                    this.totalTries = 0;
                    this.gameProfileReceived = true;
                }
                if (receivedGameProfile != null) {
                    class_310 minecraft = class_310.method_1551();
                    class_8685 skinTexture = null;
                    Optional optionalSkinTextures = (Optional)minecraft.method_1582().method_52863(receivedGameProfile).get(100L, TimeUnit.MILLISECONDS);
                    int tries = 5;
                    while (!minecraft.method_1582().method_52863(receivedGameProfile).isDone() && tries > 0) {
                        try {
                            optionalSkinTextures = (Optional)minecraft.method_1582().method_52863(receivedGameProfile).get(50L, TimeUnit.MILLISECONDS);
                        }
                        catch (TimeoutException timeoutException) {
                            --tries;
                        }
                    }
                    if (optionalSkinTextures.isPresent()) {
                        skinTexture = (class_8685)optionalSkinTextures.get();
                    }
                    if (skinTexture != null) {
                        if (!receivedGameProfile.id().equals(profile.id())) {
                            ZombifiedPlayer.LOGGER.info("The zombified player for {} has a different UUID, using random default skin!", (Object)receivedGameProfile.name());
                            ZombifiedPlayerClient.uuidMissmatches.put(profile.id(), receivedGameProfile.id());
                            ZombifiedPlayerClient.cachedPlayerSkinsByName.put(receivedGameProfile.name(), skinTexture.comp_1626().comp_3627());
                        }
                        ZombifiedPlayerClient.cachedPlayerSkinsByUUID.put(receivedGameProfile.id(), skinTexture.comp_1626().comp_3627());
                        ZombifiedPlayer.LOGGER.info("Successfully received Skin for {}, UUID: {}", (Object)receivedGameProfile.name(), (Object)receivedGameProfile.id());
                        ZombifiedPlayer.LOGGER.info("Skin Texture: {}", (Object)skinTexture.comp_1626().comp_3626());
                        ZombifiedPlayer.LOGGER.info("Skin Texture URL: {}", (Object)skinTexture.comp_1626().comp_3627());
                        this.counter = 2010;
                        this.totalTries = 0;
                        receivedGameProfile = null;
                        inProgress = null;
                        this.gameProfileReceived = false;
                        return;
                    }
                    ZombifiedPlayer.LOGGER.warn("No valid Skin was received for {}", (Object)receivedGameProfile.name());
                }
            }
            if (this.counter > 0) {
                --this.counter;
            } else {
                this.counter = 2010;
                ++this.totalTries;
                if (this.totalTries == 4) {
                    if (MainConfig.getLimitSkinFetchTries()) {
                        ZombifiedPlayer.LOGGER.warn("Could not fetch a valid Skin for {}, will stop trying.", (Object)profile.name());
                    } else {
                        this.totalTries = 0;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private GameProfile getGameProfile(GameProfile profile) {
        try {
            class_9296 profileComponent = class_9296.method_74889((String)profile.name());
            CompletableFuture futureOptionalEntry = class_310.method_1551().method_73362().method_74320(profileComponent);
            Optional optionalEntry = (Optional)futureOptionalEntry.get(100L, TimeUnit.MILLISECONDS);
            int tries = 5;
            while (!futureOptionalEntry.isDone() && tries > 0) {
                try {
                    futureOptionalEntry.get(50L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    --tries;
                }
            }
            return optionalEntry.map(class_11786.class_11787::method_73502).orElse(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        inProgress = null;
    }
}

