/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.zombifiedplayer.config;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="zombifiedplayer")
public class MainConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    public static MainConfig INSTANCE;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, a zombified player will spawn after the player gets killed by an Undead | default: true")
    private boolean spawnZombifiedPlayerAfterDeath = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, the Main and the Off Hand of the dead player will be transferred to the zombified player | default: true")
    private boolean transferMainAndOffHandToZombifiedPlayer = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, the armor of the dead player will be transferred to the zombified player | default: true")
    private boolean transferArmorToZombifiedPlayer = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, the inventory of the dead player will be transferred to the zombified player | default: true")
    private boolean transferInventoryToZombifiedPlayer = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, a zombified player will spawn no matter how the player died | default: false")
    private boolean spawnOnAnyDeath = false;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, a message will be printed out in chat that a zombified player has spawned | default: true")
    private boolean printSpawnMessageInChat = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, spawn location of the zombified player will be printed out in chat | default: false")
    private boolean printSpawnLocationInChat = false;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, zombified players can break through doors | default: true")
    private boolean zombifiedPlayersCanBreakDoors = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, zombified players are stronger, faster and have more health | default: false")
    private boolean makeTheZombifiedPlayersStronger = false;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, zombified players are immune to fire and lava | default: false")
    private boolean makeTheZombifiedPlayersImmuneToFire = false;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, the mod will stop trying to fetch the player skin after several unsuccessful tries | default: true")
    private boolean limitSkinFetchTries = true;
    @ConfigEntry.Gui.PrefixText
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, spawn zombified player after death by infection (Contagion mod needed!) | default: true")
    private boolean spawnWhenKilledByInfection = true;

    public static void init() {
        AutoConfig.register(MainConfig.class, JanksonConfigSerializer::new);
        INSTANCE = (MainConfig)AutoConfig.getConfigHolder(MainConfig.class).getConfig();
    }

    public static boolean getSpawnZombifiedPlayerAfterDeath() {
        return MainConfig.INSTANCE.spawnZombifiedPlayerAfterDeath;
    }

    public static boolean getTransferMainAndOffHandToZombifiedPlayer() {
        return MainConfig.INSTANCE.transferMainAndOffHandToZombifiedPlayer;
    }

    public static boolean getTransferArmorToZombifiedPlayer() {
        return MainConfig.INSTANCE.transferArmorToZombifiedPlayer;
    }

    public static boolean getTransferInventoryToZombifiedPlayer() {
        return MainConfig.INSTANCE.transferInventoryToZombifiedPlayer;
    }

    public static boolean getSpawnOnAnyDeath() {
        return MainConfig.INSTANCE.spawnOnAnyDeath;
    }

    public static boolean getPrintSpawnMessageInChat() {
        return MainConfig.INSTANCE.printSpawnMessageInChat;
    }

    public static boolean getPrintSpawnLocationInChat() {
        return MainConfig.INSTANCE.printSpawnLocationInChat;
    }

    public static boolean getZombifiedPlayersCanBreakDoors() {
        return MainConfig.INSTANCE.zombifiedPlayersCanBreakDoors;
    }

    public static boolean getMakeTheZombifiedPlayersStronger() {
        return MainConfig.INSTANCE.makeTheZombifiedPlayersStronger;
    }

    public static boolean getMakeTheZombifiedPlayersImmuneToFire() {
        return MainConfig.INSTANCE.makeTheZombifiedPlayersImmuneToFire;
    }

    public static boolean getLimitSkinFetchTries() {
        return MainConfig.INSTANCE.limitSkinFetchTries;
    }

    public static boolean getSpawnWhenKilledByInfection() {
        return MainConfig.INSTANCE.spawnWhenKilledByInfection;
    }
}

