/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.zombifiedplayer.event;

import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.petemc.zombifiedplayer.config.MainConfig;
import net.petemc.zombifiedplayer.entity.ModEntities;
import net.petemc.zombifiedplayer.entity.ZombifiedPlayerEntity;
import net.petemc.zombifiedplayer.util.ModCompatibility;

public class PlayerDeathEvents {
    private static class_1309 pPlayer = null;
    private static class_1309 pAttacker = null;
    private static class_1282 pSource = null;
    private static float pAmount = 0.0f;

    public PlayerDeathEvents() {
        ServerLivingEntityEvents.ALLOW_DEATH.register((entity, damageSource, amount) -> {
            pPlayer = entity;
            pAttacker = damageSource.method_5529() instanceof class_1309 ? (class_1309)damageSource.method_5529() : null;
            pSource = damageSource;
            pAmount = amount;
            PlayerDeathEvents.executeAllowDeath();
            return true;
        });
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            pPlayer = entity;
            pAttacker = damageSource.method_5529() instanceof class_1309 ? (class_1309)damageSource.method_5529() : null;
            pSource = damageSource;
            PlayerDeathEvents.executeAfterDeath();
        });
    }

    public static void executeAllowDeath() {
        class_1309 class_13092;
        if (pPlayer != null && (class_13092 = pPlayer) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_13092;
            if (!pPlayer.method_6047().method_31574(class_1802.field_8288) && !pPlayer.method_6079().method_31574(class_1802.field_8288) && (MainConfig.getSpawnOnAnyDeath() || ModCompatibility.diedFromInfection(serverPlayer) && MainConfig.getSpawnWhenKilledByInfection() || PlayerDeathEvents.attackerIsUndead() && MainConfig.getSpawnZombifiedPlayerAfterDeath())) {
                ZombifiedPlayerEntity.spawnZombifiedPlayer((class_1657)serverPlayer);
            }
        }
    }

    public static void executeAfterDeath() {
        class_1309 class_13092;
        if (pPlayer != null && (class_13092 = pPlayer) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_13092;
            if ((MainConfig.getSpawnOnAnyDeath() || ModCompatibility.diedFromInfection(serverPlayer) && MainConfig.getSpawnWhenKilledByInfection() || PlayerDeathEvents.attackerIsUndead() && MainConfig.getSpawnZombifiedPlayerAfterDeath()) && MainConfig.getPrintSpawnMessageInChat()) {
                serverPlayer.method_43502((class_2561)class_2561.method_43471((String)"zombifiedplayer.spawn.message"), false);
                if (MainConfig.getPrintSpawnLocationInChat()) {
                    class_5250 textCoordinates = class_2564.method_10885((class_2561)class_2561.method_43469((String)"chat.coordinates", (Object[])new Object[]{pPlayer.method_24515().method_10263(), pPlayer.method_24515().method_10264(), pPlayer.method_24515().method_10260()})).method_27694(style -> style.method_10977(class_124.field_1060).method_10958((class_2558)new class_2558.class_10610("/tp @s " + pPlayer.method_24515().method_10263() + " " + pPlayer.method_24515().method_10264() + " " + pPlayer.method_24515().method_10260())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"chat.coordinates.tooltip"))));
                    serverPlayer.method_43502((class_2561)class_2561.method_43469((String)"zombifiedplayer.location.message", (Object[])new Object[]{textCoordinates}), false);
                }
            }
        }
    }

    private static boolean attackerIsUndead() {
        boolean attackerIsUndead = false;
        if (pAttacker != null) {
            attackerIsUndead = pAttacker.method_5864() == class_1299.field_6051 || pAttacker.method_5864() == class_1299.field_6071 || pAttacker.method_5864() == class_1299.field_6050 || pAttacker.method_5864() == class_1299.field_6123 || pAttacker.method_5864() == class_1299.field_6054 || pAttacker.method_5864() == class_1299.field_23696 || pAttacker.method_5864() == ModEntities.ZOMBIFIED_PLAYER;
        }
        attackerIsUndead = attackerIsUndead || ModCompatibility.wasKilledByHordeZombie(pAttacker);
        return attackerIsUndead;
    }

    public static void registerEvent() {
        new PlayerDeathEvents();
    }
}

