/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.zombifiedplayer.client.render;

import com.mojang.authlib.GameProfile;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2631;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_623;
import net.minecraft.class_968;
import net.petemc.zombifiedplayer.ZombifiedPlayer;
import net.petemc.zombifiedplayer.ZombifiedPlayerClient;
import net.petemc.zombifiedplayer.client.render.ZombificationFeatureRenderer;
import net.petemc.zombifiedplayer.config.Config;
import net.petemc.zombifiedplayer.entity.ZombifiedPlayerEntity;

@Environment(value=EnvType.CLIENT)
public class ZombifiedPlayerRenderer
extends class_968<ZombifiedPlayerEntity, class_623<ZombifiedPlayerEntity>> {
    private static class_2960 TEXTURE_FALLBACK = class_2960.method_43902((String)"minecraft", (String)"textures/entity/player/wide/steve.png");
    private static GameProfile receivedGameProfile;
    private static GameProfile inProgress;
    private boolean gameProfileReceived = false;
    private final int counterSteps = 40;
    private final int maxSubTries = 5;
    private final int maxTotalTries = 5;
    private final int counterMax = 2200;
    private int counter = 2200;
    private int totalTries = 0;

    public ZombifiedPlayerRenderer(class_5617.class_5618 ctx) {
        super(ctx, new class_623(ctx.method_32167(class_5602.field_27638)), new class_623(ctx.method_32167(class_5602.field_27642)), new class_623(ctx.method_32167(class_5602.field_27643)));
        this.method_4046(new ZombificationFeatureRenderer((class_3883<ZombifiedPlayerEntity, class_623<ZombifiedPlayerEntity>>)this));
    }

    public class_2960 getTexture(ZombifiedPlayerEntity entity) {
        if (entity.getGameProfile() != null) {
            if (ZombifiedPlayerClient.cachedPlayerSkinsByUUID.containsKey(entity.getGameProfile().getId())) {
                return ZombifiedPlayerClient.cachedPlayerSkinsByUUID.get(entity.getGameProfile().getId());
            }
            if (ZombifiedPlayerClient.uuidMissmatches.containsKey(entity.getGameProfile().getId()) && (ZombifiedPlayerClient.cachedPlayerSkinsByName.containsKey(entity.gameProfile.getName()) || ZombifiedPlayerClient.cachedPlayerSkinsByName.containsKey(entity.gameProfile.getName().toLowerCase()))) {
                return ZombifiedPlayerClient.cachedPlayerSkinsByUUID.get(ZombifiedPlayerClient.uuidMissmatches.get(entity.gameProfile.getId()));
            }
            this.getPlayerSkinFromGameProfile(entity.getGameProfile());
        }
        return TEXTURE_FALLBACK;
    }

    public void setTexture(class_2960 id) {
        TEXTURE_FALLBACK = id;
    }

    public void getPlayerSkinFromGameProfile(GameProfile profile) {
        try {
            if (inProgress == null) {
                inProgress = profile;
            }
            if (!inProgress.getId().equals(profile.getId())) {
                return;
            }
            if (this.counter % 40 == 0 && this.counter > 2000 && this.totalTries < 5) {
                if (receivedGameProfile == null) {
                    if (this.counter == 2200) {
                        ZombifiedPlayer.LOGGER.info("Trying to get GameProfile for {} UUID: {}", (Object)profile.getName(), (Object)profile.getId());
                    }
                    class_2631.method_11335((GameProfile)profile, owner -> {
                        receivedGameProfile = owner;
                    });
                }
                if (!this.gameProfileReceived && receivedGameProfile != null) {
                    ZombifiedPlayer.LOGGER.info("Successfully received GameProfile for {}, UUID: {}", (Object)receivedGameProfile.getName(), (Object)receivedGameProfile.getId());
                    this.counter = 2200;
                    this.totalTries = 0;
                    this.gameProfileReceived = true;
                }
                if (receivedGameProfile != null) {
                    class_310 minecraft = class_310.method_1551();
                    class_2960 skinTexture = null;
                    skinTexture = minecraft.method_1582().method_44705(receivedGameProfile);
                    if (skinTexture != null) {
                        if (!receivedGameProfile.getId().equals(profile.getId())) {
                            ZombifiedPlayer.LOGGER.info("The zombified player for {} has a different UUID, using random default skin!", (Object)receivedGameProfile.getName());
                            ZombifiedPlayerClient.uuidMissmatches.put(profile.getId(), receivedGameProfile.getId());
                            ZombifiedPlayerClient.cachedPlayerSkinsByName.put(receivedGameProfile.getName(), skinTexture);
                        }
                        ZombifiedPlayerClient.cachedPlayerSkinsByUUID.put(receivedGameProfile.getId(), skinTexture);
                        ZombifiedPlayer.LOGGER.info("Successfully received Skin for {}, UUID: {}", (Object)receivedGameProfile.getName(), (Object)receivedGameProfile.getId());
                        ZombifiedPlayer.LOGGER.info("Skin Texture: {}", (Object)skinTexture);
                        this.counter = 2200;
                        this.totalTries = 0;
                        receivedGameProfile = null;
                        inProgress = null;
                        this.gameProfileReceived = false;
                        return;
                    }
                    ZombifiedPlayer.LOGGER.warn("No valid Skin was received for {} yet", (Object)receivedGameProfile.getName());
                }
            }
            if (this.counter > 0) {
                --this.counter;
            } else {
                this.counter = 2200;
                ++this.totalTries;
                if (this.totalTries == 4) {
                    if (Config.getLimitSkinFetchTries()) {
                        ZombifiedPlayer.LOGGER.warn("Could not fetch a valid Skin for {}, will stop trying.", (Object)profile.getName());
                    } else {
                        this.totalTries = 0;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        inProgress = null;
    }
}

