/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.zombifiedplayer.config;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@me.shedaniel.autoconfig.annotation.Config(name="zombifiedplayer")
public class Config
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    public static Config INSTANCE;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, a zombified player will spawn after the player gets killed by an Undead | default: true")
    private boolean spawnZombifiedPlayerAfterDeath = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, the Main and the Off Hand of the dead player will be transferred to the zombified player | default: true")
    private boolean transferMainAndOffHandToZombifiedPlayer = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, the armor of the dead player will be transferred to the zombified player | default: true")
    private boolean transferArmorToZombifiedPlayer = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, the inventory of the dead player will be transferred to the zombified player | default: true")
    private boolean transferInventoryToZombifiedPlayer = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, the inventory of the dead player will be transferred to the zombified player | default: true")
    private boolean transferCuriosOrTrinketItemsToZombifiedPlayer = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, a zombified player will spawn no matter how the player died | default: false")
    private boolean spawnOnAnyDeath = false;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, a message will be printed out in chat that a zombified player has spawned | default: true")
    private boolean printSpawnMessageInChat = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, spawn location of the zombified player will printed out in chat | default: false")
    private boolean printSpawnLocationInChat = false;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, zombified players can break through doors | default: true")
    private boolean zombifiedPlayersCanBreakDoors = true;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, zombified players are stronger, faster and have more health | default: false")
    private boolean makeTheZombifiedPlayersStronger = false;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, zombified players are immune to fire and lava | default: false")
    private boolean makeTheZombifiedPlayersImmuneToFire = false;
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, the mod will stop trying to fetch the player skin after several unsuccessful tries | default: true")
    private boolean limitSkinFetchTries = true;
    @ConfigEntry.Gui.PrefixText
    @ConfigEntry.Gui.Tooltip
    @Comment(value="If true, spawn zombified player after death by infection (Contagion mod needed!) | default: true")
    private boolean spawnWhenKilledByInfection = true;

    public static void init() {
        AutoConfig.register(Config.class, JanksonConfigSerializer::new);
        INSTANCE = (Config)AutoConfig.getConfigHolder(Config.class).getConfig();
    }

    public static boolean getSpawnZombifiedPlayerAfterDeath() {
        return Config.INSTANCE.spawnZombifiedPlayerAfterDeath;
    }

    public static boolean getTransferMainAndOffHandToZombifiedPlayer() {
        return Config.INSTANCE.transferMainAndOffHandToZombifiedPlayer;
    }

    public static boolean getTransferArmorToZombifiedPlayer() {
        return Config.INSTANCE.transferArmorToZombifiedPlayer;
    }

    public static boolean getTransferInventoryToZombifiedPlayer() {
        return Config.INSTANCE.transferInventoryToZombifiedPlayer;
    }

    public static boolean getTransferCuriosOrTrinketItemsToZombifiedPlayer() {
        return Config.INSTANCE.transferCuriosOrTrinketItemsToZombifiedPlayer;
    }

    public static boolean getSpawnOnAnyDeath() {
        return Config.INSTANCE.spawnOnAnyDeath;
    }

    public static boolean getPrintSpawnMessageInChat() {
        return Config.INSTANCE.printSpawnMessageInChat;
    }

    public static boolean getPrintSpawnLocationInChat() {
        return Config.INSTANCE.printSpawnLocationInChat;
    }

    public static boolean getZombifiedPlayersCanBreakDoors() {
        return Config.INSTANCE.zombifiedPlayersCanBreakDoors;
    }

    public static boolean getMakeTheZombifiedPlayersStronger() {
        return Config.INSTANCE.makeTheZombifiedPlayersStronger;
    }

    public static boolean getMakeTheZombifiedPlayersImmuneToFire() {
        return Config.INSTANCE.makeTheZombifiedPlayersImmuneToFire;
    }

    public static boolean getLimitSkinFetchTries() {
        return Config.INSTANCE.limitSkinFetchTries;
    }

    public static boolean getSpawnWhenKilledByInfection() {
        return Config.INSTANCE.spawnWhenKilledByInfection;
    }
}

