/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.zombifiedplayer.util;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_3222;
import net.petemc.contagion.casts.InfectedPlayer;
import net.petemc.undeadnights.entity.EliteZombieEntity;
import net.petemc.undeadnights.entity.HordeZombieEntity;
import net.petemc.zombifiedplayer.ZombifiedPlayer;
import net.petemc.zombifiedplayer.util.TrinketsUtil;

public class ModCompatibility {
    public static void init() {
        if (ModCompatibility.isContagionLoaded()) {
            ZombifiedPlayer.LOGGER.info("Contagion mod detected. Death by Infection can spawn Zombified Players.");
        }
        if (ModCompatibility.isUndeadNightsLoaded()) {
            ZombifiedPlayer.LOGGER.info("Undead Nights mod detected. Death by a Horde Zombie will spawn a Zombified Player.");
        }
        if (TrinketsUtil.isTrinketsLoaded()) {
            ZombifiedPlayer.LOGGER.info("Trinkets API detected. If enabled trinket items will be transferred to the Zombified Player.");
        }
    }

    public static boolean isContagionLoaded() {
        return FabricLoader.getInstance().isModLoaded("contagion");
    }

    public static boolean diedFromInfection(class_3222 serverPlayer) {
        if (ModCompatibility.isContagionLoaded() && serverPlayer instanceof InfectedPlayer) {
            InfectedPlayer infectedPlayer = (InfectedPlayer)serverPlayer;
            return infectedPlayer.contagion_playerDiedFromInfection();
        }
        return false;
    }

    public static boolean isUndeadNightsLoaded() {
        return FabricLoader.getInstance().isModLoaded("undeadnights");
    }

    public static boolean wasKilledByHordeZombie(class_1309 pAttacker) {
        if (ModCompatibility.isUndeadNightsLoaded()) {
            return pAttacker instanceof HordeZombieEntity || pAttacker instanceof EliteZombieEntity;
        }
        return false;
    }
}

