/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.api.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2487;
import net.minecraft.class_2540;

public interface ParamCodec<T> {
    public static final ParamCodec<Integer> INT = ParamCodec.of(Integer.TYPE, (o, buf) -> buf.writeInt(o.intValue()), class_2540::readInt);
    public static final ParamCodec<Long> LONG = ParamCodec.of(Long.TYPE, (o, buf) -> buf.writeLong(o.longValue()), class_2540::readLong);
    public static final ParamCodec<Float> FLOAT = ParamCodec.of(Float.TYPE, (o, buf) -> buf.writeFloat(o.floatValue()), class_2540::readFloat);
    public static final ParamCodec<Double> DOUBLE = ParamCodec.of(Double.TYPE, (o, buf) -> buf.writeDouble(o.doubleValue()), class_2540::readDouble);
    public static final ParamCodec<Boolean> BOOLEAN = ParamCodec.of(Boolean.TYPE, (o, buf) -> buf.writeBoolean(o.booleanValue()), class_2540::readBoolean);
    public static final ParamCodec<String> STRING = ParamCodec.of(String.class, (o, buf) -> buf.method_10814(o), class_2540::method_19772);
    public static final ParamCodec<UUID> UUID = ParamCodec.of(UUID.class, (o, buf) -> buf.method_10797(o), class_2540::method_10790);
    public static final ParamCodec<class_2487> NBT = ParamCodec.of(class_2487.class, (o, buf) -> buf.method_10794(o), class_2540::method_10798);
    public static final ParamCodec<ByteBuf> BYTE_BUF = ParamCodec.of(ByteBuf.class, (o, buf) -> {
        buf.method_10804(o.writerIndex());
        buf.writeBytes(o);
    }, buf -> {
        int toRead = buf.method_10816();
        ByteBuf newBb = Unpooled.buffer();
        newBb.capacity(toRead);
        buf.readBytes(newBb, toRead);
        return newBb;
    });
    public static final ParamCodec<class_2540> BUF = ParamCodec.of(class_2540.class, (o, buf) -> {
        if (o != null) {
            buf.writeBoolean(true);
            buf.method_10804(o.readableBytes());
            buf.asByteBuf().writeBytes(o.asByteBuf());
        } else {
            buf.writeBoolean(false);
        }
    }, buf -> {
        boolean present = buf.readBoolean();
        if (present) {
            int bytes = buf.method_10816();
            return PacketByteBufs.copy((ByteBuf)PacketByteBufs.readSlice((ByteBuf)buf, (int)bytes));
        }
        return null;
    });
    public static final ParamCodec<FloatList> FLOAT_LIST = ParamCodec.of(FloatList.class, (o, buf) -> {
        buf.method_10804(o.size());
        FloatListIterator floatListIterator = o.iterator();
        while (floatListIterator.hasNext()) {
            float f = ((Float)floatListIterator.next()).floatValue();
            buf.writeFloat(f);
        }
    }, buf -> {
        int size = buf.method_10816();
        float[] floats = new float[size];
        for (int i = 0; i < size; ++i) {
            floats[i] = buf.readFloat();
        }
        return FloatList.of((float[])floats);
    });
    public static final ParamCodec<IntList> INT_LIST = ParamCodec.of(IntList.class, (o, buf) -> {
        buf.method_10804(o.size());
        IntListIterator intListIterator = o.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            buf.writeInt(i);
        }
    }, buf -> {
        int size = buf.method_10816();
        int[] ints = new int[size];
        for (int i = 0; i < size; ++i) {
            ints[i] = buf.readInt();
        }
        return IntList.of((int[])ints);
    });

    public Class<T> clazz();

    public T decode(class_2540 var1);

    public void encode(T var1, class_2540 var2);

    public static <T> ParamCodec<List<T>> list(ParamCodec<T> codec) {
        return ParamCodec.of(List.class, (o, buf) -> {
            buf.writeInt(o.size());
            for (Object t : o) {
                codec.encode(t, buf);
            }
        }, buf -> {
            int size = buf.readInt();
            return IntStream.range(0, size).mapToObj(i -> codec.decode(buf)).toList();
        });
    }

    public static <T extends Enum<T>> ParamCodec<T> ofEnum(Class<T> tEnum) {
        return ParamCodec.of(tEnum, (t, buf) -> buf.method_10804(t.ordinal()), buf -> ((Enum[])tEnum.getEnumConstants())[buf.method_10816()]);
    }

    public static <T> ParamCodec<T> of(final Class<T> clazz, final Encoder<T> encoder, final Decoder<T> decoder) {
        return new ParamCodec<T>(){

            @Override
            public Class<T> clazz() {
                return clazz;
            }

            @Override
            public T decode(class_2540 buf) {
                return decoder.decode(buf);
            }

            @Override
            public void encode(T t, class_2540 buf) {
                encoder.encode(t, buf);
            }
        };
    }

    public static <T> ParamCodec<T> ofNullable(ParamCodec<T> codec) {
        return ParamCodec.of(codec.clazz(), (o, b) -> {
            boolean present = o != null;
            b.writeBoolean(present);
            if (present) {
                codec.encode(o, b);
            }
        }, b -> {
            boolean present = b.readBoolean();
            if (present) {
                return codec.decode(b);
            }
            return null;
        });
    }

    public static interface Encoder<T> {
        public void encode(T var1, class_2540 var2);
    }

    public static interface Decoder<T> {
        public T decode(class_2540 var1);
    }
}

