/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.client.screen.auto;

import com.neep.meatlib.client.screen.auto.Panel;
import com.neep.meatlib.client.screen.primitive.Point;
import com.neep.meatlib.client.screen.primitive.Rectangle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_364;
import net.minecraft.class_4068;

public class HStackPanel
extends Panel {
    protected final int padding;
    protected final int elementPadding;
    protected final boolean fitElements;
    protected final List<Point.Mutable> children = new ObjectArrayList();
    private final List<class_4068> drawables = new ObjectArrayList();
    private final List<class_364> elements = new ObjectArrayList();
    protected int elementsWidth;
    protected int sideMargin = 0;

    public HStackPanel(int padding, int elementPadding, boolean fitElements) {
        this.padding = padding;
        this.elementPadding = elementPadding;
        this.fitElements = fitElements;
    }

    public HStackPanel(int padding, int elementPadding) {
        this(padding, elementPadding, false);
    }

    protected int fitElements() {
        int maxH = 0;
        for (Point.Mutable child : this.children) {
            if (!this.fitElements && child instanceof Rectangle.Mutable) continue;
            maxH = Math.max(((Rectangle)((Object)child)).h(), maxH);
        }
        return maxH + 2 * this.padding + this.sideMargin;
    }

    protected int xOffset() {
        return 0;
    }

    @Override
    public void init() {
        int xOffset = this.xOffset();
        this.elementsWidth = 0;
        if (this.fitElements) {
            this.h = this.fitElements();
        }
        for (Point.Mutable child : this.children) {
            Rectangle rectangle = (Rectangle)((Object)child);
            child.setPos(this.x + this.padding + xOffset, this.y + this.padding);
            xOffset += rectangle.w() + this.elementPadding;
            this.elementsWidth += rectangle.w() + this.elementPadding;
        }
    }

    @Override
    public int w() {
        if (this.fitElements) {
            this.w = this.fitElements();
        }
        return this.w;
    }

    @Override
    protected List<class_4068> drawables() {
        return this.drawables;
    }

    @Override
    public List<class_364> method_25396() {
        return this.elements;
    }

    public <T extends class_4068 & Point.Mutable & class_364> HStackPanel addChild(T widget) {
        this.children.add(widget);
        this.drawables.add(widget);
        this.elements.add(widget);
        return this;
    }

    public <T extends class_4068 & Point.Mutable & class_364> T addChildIn(T widget) {
        this.children.add(widget);
        this.drawables.add(widget);
        this.elements.add(widget);
        return widget;
    }
}

