/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.client.screen.widget;

import com.neep.meatlib.client.screen.primitive.Rectangle;
import com.neep.meatlib.client.screen.widget.AbstractNumberTextField;
import com.neep.neepbus.NeepBus;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_437;

public class DoubleNumberTextField
extends AbstractNumberTextField<Double>
implements Rectangle.Mutable {
    private final Runnable update;
    private final double min;
    private final double max;
    private final float minIncrement;
    private final float maxIncrement;

    public DoubleNumberTextField(class_327 textRenderer, int x, int y, int width, int height, class_2561 prefix, Runnable update, double min, double max) {
        this(textRenderer, x, y, width, height, prefix, update, min, max, 1, 16);
    }

    public DoubleNumberTextField(class_327 textRenderer, int x, int y, int width, int height, class_2561 prefix, Runnable update, double min, double max, int minIncrement, int maxIncrement) {
        super(textRenderer, x, y, width, height, prefix);
        this.update = update;
        this.min = min;
        this.max = max;
        this.minIncrement = minIncrement;
        this.maxIncrement = maxIncrement;
    }

    @Override
    protected void update() {
        this.update.run();
    }

    @Override
    protected boolean isValidString(String text) {
        return text.matches("[+\\-0-9E.]*");
    }

    @Override
    protected String valueToString(Double value) {
        return NeepBus.formatDouble(value);
    }

    protected double parseValue(String text) {
        try {
            return class_3532.method_15350((double)Double.parseDouble(text), (double)this.min, (double)this.max);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private float scrollMultiplier() {
        return class_437.method_25442() ? this.minIncrement : this.maxIncrement;
    }

    @Override
    protected Double applyScroll(String text, double amount) {
        return class_3532.method_15350((double)((int)(this.parseValue(text) + amount * (double)this.scrollMultiplier())), (double)this.min, (double)this.max);
    }

    public double parse() {
        return this.parseValue(this.text());
    }
}

