/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.client.screen.widget.config;

import com.neep.meatlib.client.screen.primitive.Rectangle;
import com.neep.meatlib.client.screen.widget.ClickableWidget;
import com.neep.meatlib.client.screen.widget.ParentWidget;
import com.neep.meatlib.client.screen.widget.config.ConfigTextField;
import com.neep.meatlib.screen.ConfigWidgetHandler;
import com.neep.neepmeat.client.screen.util.Background;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public abstract class ConfigWidget<T>
extends ParentWidget {
    protected final ConfigWidgetHandler<T> handler;
    protected final List<ClickableWidget> trackedFields = new ObjectArrayList();

    public ConfigWidget(int x, int y, int w, int h, ConfigWidgetHandler<T> handler) {
        super(x, y, w, h);
        this.handler = handler;
        handler.updateParamsS2C.receiver(this::updateParams);
    }

    protected abstract T createValues();

    protected float scrollMultiplier() {
        return class_437.method_25442() ? 1.0f : 10.0f;
    }

    protected <W extends ClickableWidget> W addTrackedField(W field) {
        this.trackedFields.add(field);
        return field;
    }

    @Override
    public void close() {
        super.close();
        this.update();
    }

    public void update() {
        try {
            T values = this.createValues();
            this.handler.receiveParamsC2S.emitter().update(values);
            for (ClickableWidget field : this.trackedFields) {
                if (!(field instanceof ConfigTextField)) continue;
                ConfigTextField configTextField = (ConfigTextField)field;
                configTextField.setDirty(false);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void init() {
        super.init();
        Background background = new Background(this.x, this.y, this.w, this.h, 6);
        this.addChild(background);
        int yOff = this.y;
        for (ClickableWidget field : this.trackedFields) {
            this.addChild(field);
            if (field instanceof Rectangle.Mutable) {
                Rectangle.Mutable mutable = (Rectangle.Mutable)((Object)field);
                mutable.setDims(this.x, yOff, this.w(), field.h());
            } else {
                field.setPos(this.x, yOff);
            }
            yOff += field.h() + 1;
        }
        this.h = yOff - this.y;
        background.setH(this.h);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.method_25370() && keyCode == 69) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public void tick() {
    }

    @Override
    public void method_37020(class_6382 builder) {
    }

    @Override
    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void setW(int w) {
        this.w = w;
    }

    protected abstract void updateParams(T var1);
}

