/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.client.screen.widget.config;

import com.neep.meatlib.client.screen.widget.NumberListConfigWidget;
import com.neep.meatlib.screen.NumberListConfigHandler;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class IntListConfigWidget
extends NumberListConfigWidget<Integer, IntList> {
    public IntListConfigWidget(int x, int y, int w, int h, NumberListConfigHandler<Integer, IntList> handler) {
        super(x, y, w, h, handler);
    }

    @Override
    protected IntList createList() {
        return new IntArrayList();
    }

    @Override
    protected Integer parseValue(String text) {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    protected Integer zero() {
        return 0;
    }

    @Override
    protected String valueToString(Integer value) {
        return Integer.toString(value);
    }

    @Override
    protected boolean validString(String string) {
        return string.matches("[+\\-0-9E]*");
    }

    @Override
    protected Integer applyScroll(String text, Double amount) {
        return (int)((double)this.parseValue(text).intValue() + amount * (double)this.scrollMultiplier());
    }
}

