/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.fluid;

import com.neep.meatlib.fluid.BuiltFluid;
import com.neep.meatlib.fluid.StandardBuiltFluid;

public class FluidBuilder {
    private final String namespace;
    private final String baseName;
    private int levelDecrease = 2;
    private int tickRate = 5;
    private boolean isInfinite = false;
    private boolean makeItem = false;
    private boolean makeBlock = false;
    private FluidFactory<?> fluidFactory;

    public FluidBuilder(String namespace, String baseName) {
        this.namespace = namespace;
        this.baseName = baseName;
        this.fluidFactory = StandardBuiltFluid::new;
    }

    public FluidBuilder levelDecrease(int levelDecrease) {
        this.levelDecrease = levelDecrease;
        return this;
    }

    public FluidBuilder tickRate(int tickRate) {
        this.tickRate = tickRate;
        return this;
    }

    public FluidBuilder isInfinite(boolean isInfinite) {
        this.isInfinite = isInfinite;
        return this;
    }

    public FluidBuilder fluidFactory(FluidFactory<?> factory) {
        this.fluidFactory = factory;
        return this;
    }

    public FluidBuilder withItem() {
        this.makeItem = true;
        return this;
    }

    public FluidBuilder withBlock() {
        this.makeBlock = true;
        return this;
    }

    public BuiltFluid<?, ?> build() {
        return this.fluidFactory.create(this.namespace, this.baseName, this.levelDecrease, this.tickRate, this.isInfinite, this.makeBlock, this.makeItem);
    }

    public static interface FluidFactory<T extends BuiltFluid<?, ?>> {
        public T create(String var1, String var2, int var3, int var4, boolean var5, boolean var6, boolean var7);
    }
}

