/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.larkdown.command;

import com.neep.meatlib.larkdown.command.LarkdownCommand;
import com.neep.meatlib.larkdown.content.ImageLarkdownContent;
import com.neep.meatlib.larkdown.content.TextLarkdownContent;
import com.neep.meatlib.larkdown.parser.Alignment;
import com.neep.meatlib.larkdown.parser.Format;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public interface LarkdownCommands {
    public static final Map<String, LarkdownCommand> DEFAULT_COMMANDS = Map.of("image", (options, arguments, acceptor) -> acceptor.accept(new ImageLarkdownContent(options.getInt("width", 64), options.getInt("height", 64), options.getFloat("scale", 1.0f), arguments.get(0))), "centering", (options, arguments, acceptor) -> acceptor.accept(new TextLarkdownContent(arguments.get(0), Format.NONE, Alignment.CENTRE)));
    public static final LarkdownCommands DEFAULT = new LarkdownCommands(){

        @Override
        @Nullable
        public LarkdownCommand get(String name) {
            return (LarkdownCommand)DEFAULT_COMMANDS.get(name);
        }
    };

    @Nullable
    public LarkdownCommand get(String var1);

    public static class Mutable
    implements LarkdownCommands {
        private final Map<String, LarkdownCommand> map = new HashMap<String, LarkdownCommand>();

        public Mutable() {
            this.map.putAll(DEFAULT_COMMANDS);
        }

        public void register(String name, LarkdownCommand command) {
            this.map.put(name, command);
        }

        @Override
        @Nullable
        public LarkdownCommand get(String name) {
            return this.map.get(name);
        }
    }
}

