/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.larkdown.parser;

import com.neep.meatlib.larkdown.LarkdownParseException;
import com.neep.meatlib.larkdown.LarkdownParser;
import com.neep.meatlib.larkdown.command.CommandArguments;
import com.neep.meatlib.larkdown.command.CommandOptions;
import com.neep.meatlib.larkdown.command.LarkdownCommand;
import com.neep.meatlib.larkdown.command.LarkdownCommands;
import com.neep.meatlib.larkdown.parser.ReaderTokenView;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;

public class LineCommandParser
implements LarkdownParser.ContentParser {
    private final LarkdownCommands commands;

    public LineCommandParser(LarkdownCommands commands) {
        this.commands = commands;
    }

    @Override
    public boolean matches(String line) {
        return line.startsWith("\\");
    }

    @Override
    public void parse(BufferedReader reader, LarkdownParser.ContentAcceptor acceptor) throws IOException, LarkdownParseException {
        ReaderTokenView view = new ReaderTokenView(reader);
        view.next();
        this.parseCommand(view, acceptor);
        String remaining = reader.readLine();
    }

    public void parseCommand(ReaderTokenView view, LarkdownParser.ContentAcceptor acceptor) throws IOException, LarkdownParseException {
        String name = view.nextIdentifier();
        LarkdownCommand command = this.commands.get(name);
        if (command == null) {
            throw new LarkdownParseException(String.format("Unknown command: %s", name));
        }
        LineCommandParser.parseCommand(view, command, acceptor, name);
    }

    private static void parseCommand(ReaderTokenView view, LarkdownCommand command, LarkdownParser.ContentAcceptor acceptor, String context) throws IOException, LarkdownParseException {
        int c = view.next();
        CommandOptions options = new CommandOptions();
        CommandArguments arguments = new CommandArguments();
        if (c == 91) {
            options = new CommandOptions(LineCommandParser.lookAhead(view, ']', context));
            c = view.next();
        }
        if (c == 123) {
            ObjectArrayList found = new ObjectArrayList();
            boolean exit = false;
            do {
                String thing = LineCommandParser.lookAhead(view, '}', context);
                found.add(thing);
                if (view.peek() == '{') continue;
                exit = true;
            } while (!exit);
            arguments = new CommandArguments((List<String>)found);
        }
        command.apply(options, arguments, acceptor);
    }

    private static String lookAhead(ReaderTokenView view, char end, String context) throws IOException, LarkdownParseException {
        int c;
        StringBuilder sb = new StringBuilder();
        do {
            if ((c = view.next()) == end) {
                return sb.toString();
            }
            sb.appendCodePoint(c);
        } while (c != -1);
        throw new LarkdownParseException(String.format("Reached EOF while parsing command %s", context));
    }
}

