/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.util;

import com.neep.meatlib.util.TokenView;
import com.neep.neepmeat.neepasm.NeepASM;
import org.jetbrains.annotations.Nullable;

public class StringTokenView
extends TokenView {
    private final String string;
    private int offset = 0;
    private final int lineOffset;
    private int currentLine = 0;

    public StringTokenView(String string, int lineOffset) {
        this.string = string;
        this.lineOffset = lineOffset;
    }

    public StringTokenView(String string) {
        this(string, 0);
    }

    public int pos() {
        return this.offset;
    }

    public int line() {
        return this.lineOffset + (int)this.string.substring(0, this.offset).lines().count() - 1;
    }

    public int linePos() {
        int lastLine = this.string.substring(0, this.offset).lastIndexOf(10);
        return this.offset - lastLine - 1;
    }

    public char next() {
        if (this.offset >= this.string.length()) {
            return '\u0000';
        }
        return this.string.charAt(this.offset++);
    }

    public void next(int n) {
        for (int i = 0; i < n; ++i) {
            this.next();
        }
    }

    public void nextLine() {
        while (this.peek() != '\n' && !this.isTerminator(this.peek()) && this.offset < this.string.length()) {
            this.next();
        }
        this.next();
    }

    public char nextThing() {
        this.fastForward();
        return this.next();
    }

    public char peekThing() {
        this.fastForward();
        return this.peek();
    }

    public char peek() {
        if (this.offset >= this.string.length()) {
            return '\u0000';
        }
        return this.string.charAt(this.offset);
    }

    public char peek(int n) {
        if (this.offset + n >= this.string.length()) {
            return '\u0000';
        }
        return this.string.charAt(this.offset + n);
    }

    public void fastForward() {
        while (this.peek() != '\u0000' && this.isNotLineEnd(this.peek())) {
            this.next();
        }
    }

    public String nextBlob() {
        this.fastForward();
        StringBuilder builder = new StringBuilder();
        while (this.peek() != '\u0000' && !this.isNotLineEnd(this.peek())) {
            builder.append(this.next());
        }
        return builder.toString();
    }

    public String nextIdentifier() {
        this.fastForward();
        int index = 0;
        StringBuilder builder = new StringBuilder();
        while (this.isIdentifier(index, this.peek())) {
            builder.append(this.next());
            ++index;
        }
        return builder.toString();
    }

    public String nextIntegerString() {
        this.fastForward();
        StringBuilder builder = new StringBuilder();
        int index = 0;
        while (StringTokenView.isDigit(index, this.peek())) {
            builder.append(this.next());
            ++index;
        }
        return builder.toString();
    }

    public int nextInteger() throws NeepASM.ParseException {
        String s = this.nextIntegerString();
        return StringTokenView.parseInteger(s);
    }

    public static int parseInteger(String s) throws NeepASM.ParseException {
        if (s.equals("-")) {
            return 0;
        }
        int radix = 10;
        if (s.startsWith("0x")) {
            radix = 16;
        } else if (s.startsWith("0b")) {
            radix = 2;
        }
        try {
            return Integer.parseInt(radix == 10 ? s : s.substring(2), radix);
        }
        catch (NumberFormatException e) {
            throw new NeepASM.ParseException(e.getMessage());
        }
    }

    @Nullable
    public String nextString() {
        this.fastForward();
        if (this.peek() != '\"' || this.lineEnded()) {
            return null;
        }
        this.next();
        StringBuilder builder = new StringBuilder();
        while (this.peek() != '\"') {
            if (this.lineEnded()) {
                return null;
            }
            builder.append(this.next());
        }
        this.next();
        return builder.toString();
    }

    public Mark mark() {
        return new Mark(this.offset, this.currentLine);
    }

    public static boolean isDigit(char c) {
        return c == '-' || Character.isDigit(c);
    }

    private static boolean isDigit(int index, char c) {
        return index == 1 && (c == 'x' || c == 'b') || StringTokenView.isDigit(c) || Character.digit(c, 16) != -1;
    }

    public boolean lineEnded() {
        return this.peek() == '\n' || this.isTerminator(this.peek()) || this.peek() == '\u0000';
    }

    protected boolean isNotLineEnd(char c) {
        return c != '\n' && !this.isTerminator(c) && Character.isWhitespace(c) || c == '\u0000';
    }

    public boolean eof() {
        return this.offset >= this.string.length();
    }

    public String toString() {
        return "TokenView: " + this.peek();
    }

    public class Mark
    extends TokenView.Mark {
        int saved;
        int savedLine;

        public Mark(int saved, int currentLine) {
            this.saved = saved;
            this.savedLine = currentLine;
        }

        @Override
        public void close() {
            if (!this.commit) {
                StringTokenView.this.offset = this.saved;
                StringTokenView.this.currentLine = this.savedLine;
            }
        }
    }
}

