/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.component;

import com.neep.meatlib.MeatLib;
import com.neep.meatweapons.client.meatgun.RecoilManager;
import com.neep.meatweapons.component.MeatgunComponent;
import com.neep.meatweapons.item.meatgun.Meatgun;
import com.neep.meatweapons.item.meatgun.MeatgunAnimationManager;
import com.neep.meatweapons.meatgun.RootModuleCache;
import com.neep.meatweapons.meatgun.RootModuleHolder;
import com.neep.meatweapons.network.MWAttackC2SPacket;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.item.ItemComponent;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;

public class MeatgunComponentImpl
extends ItemComponent
implements MeatgunComponent {
    @Nullable
    private RecoilManager recoil;
    private RootModuleHolder holder = this.initUUID();
    private boolean dirty = true;
    private boolean invalidated = false;
    @Environment(value=EnvType.CLIENT)
    private MeatgunAnimationManager animationManager;

    public MeatgunComponentImpl(class_1799 stack, ComponentKey<MeatgunComponent> key) {
        super(stack, key);
        this.holder.setComponent(this);
        this.holder.readNbt(this.getOrCreateRootTag());
    }

    @Override
    public RootModuleHolder getRootHolder() {
        return this.holder;
    }

    @Override
    public RootModuleHolder initUUID() {
        Meatgun meatgun = (Meatgun)this.getStack().method_7909();
        boolean isServer = !MeatLib.isClient();
        UUID foundUUID = this.getUuid("meatgun_uuid");
        if (foundUUID == null || foundUUID.equals(RootModuleHolder.NULL_UUID)) {
            foundUUID = RootModuleHolder.NULL_UUID;
            this.putUuid("meatgun_uuid", foundUUID);
            return new RootModuleHolder(meatgun);
        }
        return RootModuleCache.getOrCreate(this, foundUUID, meatgun, isServer);
    }

    @Override
    public void trigger(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        this.holder.root.trigger(world, player, stack, id, pitch, yaw, handType, hand);
    }

    @Override
    public void release(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        this.holder.root.release(world, player, stack, id, pitch, yaw, handType, hand);
    }

    @Override
    public void tickTrigger(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        this.holder.root.tickTrigger(world, player, stack, id, pitch, yaw, handType, hand);
    }

    @Override
    public RecoilManager getRecoil() {
        if (this.recoil == null) {
            this.recoil = RecoilManager.getOrCreate(this.getUuid());
        }
        return this.recoil;
    }

    @Override
    @Nullable
    public MeatgunAnimationManager getAnimationManager() {
        return this.animationManager;
    }

    @Override
    public class_1799 getStack() {
        return this.stack;
    }

    @Override
    public void commonTick(class_1657 player) {
        if (this.getUuid().equals(RootModuleHolder.NULL_UUID)) {
            UUID newUUID = UUID.randomUUID();
            this.putUuid("meatgun_uuid", newUUID);
            Meatgun meatgun = (Meatgun)this.getStack().method_7909();
            this.holder = RootModuleCache.getOrCreate(this, newUUID, meatgun, !player.method_37908().method_8608());
        }
        this.holder.root.tick(player);
        if (!player.method_37908().method_8608()) {
            if (this.dirty) {
                this.holder.root.writeNbt(this.getOrCreateRootTag());
                this.dirty = false;
            }
            if (this.invalidated) {
                this.holder.root.readNbt(this.getOrCreateRootTag());
                this.invalidated = false;
            }
        }
    }

    @Override
    public void clientTick(class_1657 player) {
        if (this.animationManager == null) {
            this.animationManager = MeatgunAnimationManager.getOrCreate(this.getUuid(), (Meatgun)this.stack.method_7909());
        }
        this.animationManager.tick(this);
    }

    @Override
    public void markDirty() {
        this.holder.root.writeNbt(this.getOrCreateRootTag());
    }

    public void onTagInvalidated() {
        super.onTagInvalidated();
        this.dirty = true;
        this.invalidated = true;
    }

    @Override
    public UUID getUuid() {
        return this.getUuid("meatgun_uuid");
    }
}

