/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.meatgun.module;

import com.neep.meatweapons.meatgun.RootModuleHolder;
import com.neep.meatweapons.meatgun.module.MeatgunModule;
import com.neep.meatweapons.meatgun.module.ModuleSlot;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.joml.Matrix4f;

public abstract class AbstractMeatgunModule
implements MeatgunModule {
    protected Matrix4f transform = new Matrix4f();
    protected List<ModuleSlot> slots;
    protected UUID uuid = UUID.randomUUID();
    protected final RootModuleHolder.Listener listener;

    public AbstractMeatgunModule(RootModuleHolder.Listener listener, List<ModuleSlot> slots) {
        this.listener = listener;
        this.slots = Collections.unmodifiableList(slots);
    }

    public AbstractMeatgunModule(RootModuleHolder.Listener listener) {
        this.listener = listener;
        this.slots = Collections.emptyList();
    }

    protected void setSlots(List<ModuleSlot> slots) {
        this.slots = Collections.unmodifiableList(slots);
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public void setTransform(Matrix4f transform) {
        this.transform = transform;
    }

    @Override
    public List<ModuleSlot> getChildren() {
        return this.slots;
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_25927("uuid", this.uuid);
        float[] fs = this.transform.get(new float[16]);
        nbt.method_10539("transform", IntStream.range(0, fs.length).map(i -> Float.floatToIntBits(fs[i])).toArray());
        class_2499 slotsNbt = new class_2499();
        for (ModuleSlot slot : this.slots) {
            class_2487 slotNbt = MeatgunModule.toNbt(slot.get());
            slotsNbt.add((Object)slotNbt);
        }
        nbt.method_10566("slots", (class_2520)slotsNbt);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        int i;
        int[] bits;
        if (nbt.method_25928("uuid")) {
            this.uuid = nbt.method_25926("uuid");
        }
        if ((bits = nbt.method_10561("transform")).length == 16) {
            float[] fs = new float[bits.length];
            for (i = 0; i < bits.length; ++i) {
                fs[i] = Float.intBitsToFloat(bits[i]);
            }
            this.transform.set(fs);
        } else {
            this.transform = new Matrix4f();
        }
        class_2499 list = nbt.method_10554("slots", 10);
        for (i = 0; i < this.slots.size(); ++i) {
            MeatgunModule.Type<? extends MeatgunModule> preType = this.slots.get(i).get().getType();
            class_2487 slotNbt = list.method_10602(i);
            MeatgunModule.Type<?> type = MeatgunModule.readType(slotNbt);
            if (type != preType) {
                Object module = type.create(this.listener, slotNbt);
                module.readNbt(slotNbt);
                this.slots.get(i).set((MeatgunModule)module);
                continue;
            }
            this.slots.get(i).get().readNbt(slotNbt);
        }
    }
}

