/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.particle;

import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.neep.meatlib.client.RotationAxis;
import com.neep.meatweapons.client.BeamRenderer;
import com.neep.meatweapons.client.particle.PhageRaySplodgeParticle;
import com.neep.meatweapons.component.MeatgunComponent;
import com.neep.meatweapons.init.MWComponents;
import com.neep.meatweapons.meatgun.module.MeatgunModule;
import com.neep.meatweapons.meatgun.module.MeatgunModules;
import com.neep.meatweapons.meatgun.module.ShortPhageRayModule;
import com.neep.neepmeat.client.particle.PhageRayGraphicsEffect;
import com.neep.neepmeat.machine.live_machine.process.PhageRayProcess;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_703;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class SmallPhageRayGraphicsEffect
extends PhageRayGraphicsEffect {
    public static final class_1921 TRAIL_LAYER = class_1921.method_42600((class_2960)new class_2960("neepmeat", "textures/misc/phage_ray_beam_2.png"));
    public static final class_1921 TUBE_LAYER = class_1921.method_42600((class_2960)new class_2960("neepmeat", "textures/block/phage_ray/beam_small.png"));
    @Nullable
    private PhageRaySplodgeParticle particle;
    private final class_310 client = class_310.method_1551();

    public SmallPhageRayGraphicsEffect(class_1937 world, UUID uuid, class_2540 buf) {
        super(world, uuid, PhageRayProcess.PhageRay.EMPTY, buf);
        class_1268 hand = buf.readBoolean() ? class_1268.field_5810 : class_1268.field_5808;
        class_1297 entity = world.method_8469(buf.method_10816());
        if (entity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)entity;
            MeatgunComponent component = (MeatgunComponent)MWComponents.MEATGUN.getNullable((Object)playerEntity.method_5998(hand));
            if (component != null) {
                MeatgunModule module = component.getRootHolder().moduleCache().findModule(buf.method_10790());
                if (module instanceof ShortPhageRayModule) {
                    ShortPhageRayModule phageRayModule = (ShortPhageRayModule)module;
                    this.parent = new RayDelegate(playerEntity, component, phageRayModule, hand);
                } else {
                    this.remove();
                }
            } else {
                this.remove();
            }
        } else {
            this.remove();
        }
    }

    @Override
    protected class_1921 getTrailLayer() {
        return TRAIL_LAYER;
    }

    @Override
    protected class_1921 getTubeLayer() {
        return TUBE_LAYER;
    }

    @Override
    public void tick() {
        if (this.parent.trigger() && (this.particle == null || !this.particle.method_3086()) && PhageRaySplodgeParticle.FACTORY != null) {
            this.particle = PhageRaySplodgeParticle.FACTORY.createParticle(this.client.field_1687, this.parent);
            this.client.field_1713.method_3058((class_703)this.particle);
            class_243 end = this.parent.getClientBeamEnd(this.parent.getBeamOrigin(), 0.0f);
            this.particle.method_3063(end.field_1352, end.field_1351, end.field_1350);
            this.particle.setPrevPos(end.field_1352, end.field_1351, end.field_1350);
            this.particle.method_3087(0.4f);
        }
        if (this.particle != null && !this.parent.trigger()) {
            this.particle.method_3085();
        }
        super.tick();
    }

    @Override
    public void render(class_4184 camera, class_4587 matrices, class_4597 vcp, float tickDelta) {
        if (!this.parent.trigger()) {
            return;
        }
        this.start = this.parent.getBeamOrigin();
        this.end = this.parent.getClientBeamEnd(this.start, tickDelta);
        if (this.particle != null) {
            this.particle.method_3063(this.end.field_1352, this.end.field_1351, this.end.field_1350);
            this.particle.setPrevPos(this.end.field_1352, this.end.field_1351, this.end.field_1350);
        }
        matrices.method_22903();
        class_4588 consumer = vcp.getBuffer(this.getTrailLayer());
        BeamRenderer.renderBeam2(matrices, consumer, camera.method_19326(), this.start, this.end, ((float)this.parent.getAge() + tickDelta) * 40.0f, 255, 255, 255, 255, this.scale, 255);
        BeamRenderer.renderTube(camera.method_19326(), this.start, this.end, tickDelta, this.parent.getAge(), matrices, vcp.getBuffer(this.getTubeLayer()), 255, 0.55f * this.scale);
        matrices.method_22909();
    }

    @Override
    public void remove() {
        super.remove();
        if (this.particle != null) {
            this.particle.method_3085();
        }
    }

    private static class RayDelegate
    implements PhageRayProcess.PhageRay {
        private final class_1657 player;
        private final MeatgunComponent component;
        private final ShortPhageRayModule module;
        private final class_1268 hand;
        private final class_310 client = class_310.method_1551();

        public RayDelegate(class_1657 player, MeatgunComponent component, ShortPhageRayModule module, class_1268 hand) {
            this.player = player;
            this.component = component;
            this.module = module;
            this.hand = hand;
        }

        @Override
        public boolean trigger() {
            return this.module.triggerHeld();
        }

        @Override
        public class_243 getBeamOrigin() {
            float tickDelta = this.client.method_1488();
            Vector4f v = new Vector4f(0.0f, 0.0f, -this.player.method_17681() / 2.0f + 0.1f, 1.0f);
            Matrix4f moduleTransform = this.module.getTransform();
            int rightHand = this.player.method_6068() == class_1306.field_6183 && this.hand == class_1268.field_5808 ? 1 : -1;
            boolean staff = this.component.getRootHolder().root.getType() == MeatgunModules.BASE_STAFF;
            Matrix4f transform = new Matrix4f();
            transform.rotate((Quaternionfc)RotationAxis.NEGATIVE_Y.rotationDegrees(180.0f + this.player.method_5705(tickDelta)));
            if (staff) {
                transform.rotate((Quaternionfc)RotationAxis.NEGATIVE_X.rotationDegrees(90.0f + this.player.method_5695(tickDelta)));
                transform.translate(0.0f, 0.0f, -0.2f);
            } else {
                transform.rotate((Quaternionfc)RotationAxis.NEGATIVE_X.rotationDegrees(this.player.method_5695(tickDelta)));
            }
            transform.translate((float)rightHand * 0.2f, 0.0f, 0.0f);
            transform.mul((Matrix4fc)moduleTransform);
            transform.transform(v);
            class_243 pos = this.player.method_30950(this.client.method_1488()).method_1031(0.0, (double)this.player.method_5751(), 0.0);
            return new class_243(pos.field_1352 + (double)v.x, pos.field_1351 + (double)v.y, pos.field_1350 + (double)v.z);
        }

        @Override
        public class_243 getClientBeamEnd(class_243 start, float tickDelta) {
            class_243 direct = this.player.method_5745(15.0, this.client.method_1488(), false).method_17784();
            class_243 facing = this.player.method_5828(tickDelta);
            class_243 p2d = direct.method_1020(start);
            double dist = facing.method_1026(p2d) - 0.1;
            return new class_243(start.field_1352 + facing.field_1352 * dist, start.field_1351 + facing.field_1351 * dist, start.field_1350 + facing.field_1350 * dist);
        }

        @Override
        public int getAge() {
            return AnimationTickHolder.getTicks();
        }
    }
}

